/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.arithmetic;

import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.arithmetic.AbstractArithmeticOperation;
import org.apache.vxquery.runtime.functions.cast.CastToDecimalOperation;

public class DivideOperation
extends AbstractArithmeticOperation {
    protected final ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
    private DoublePointable doublep = (DoublePointable)DoublePointable.FACTORY.createPointable();
    private XSDecimalPointable decp1 = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
    private XSDecimalPointable decp2 = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();

    @Override
    public void operateDateDate(XSDatePointable datep, XSDatePointable datep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDateDTDuration(XSDatePointable datep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDatetimeDatetime(XSDateTimePointable datetimep, XSDateTimePointable datetimep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDatetimeDTDuration(XSDateTimePointable datetimep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDatetimeYMDuration(XSDateTimePointable datetimep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDateYMDuration(XSDatePointable datep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDecimalDecimal(XSDecimalPointable decp1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        double value1 = decp1.doubleValue();
        double value2 = decp2.doubleValue();
        if (value2 == 0.0) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        this.abvsInner.reset();
        this.doublep.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength());
        this.doublep.setDouble(value1 /= value2);
        CastToDecimalOperation castToDecmial = new CastToDecimalOperation();
        castToDecmial.convertDouble(this.doublep, dOut);
    }

    @Override
    public void operateDecimalDouble(XSDecimalPointable decp1, DoublePointable doublep2, DataOutput dOut) throws SystemException, IOException {
        double value = decp1.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= doublep2.doubleValue());
    }

    @Override
    public void operateDecimalDTDuration(XSDecimalPointable decp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDecimalFloat(XSDecimalPointable decp1, FloatPointable floatp2, DataOutput dOut) throws SystemException, IOException {
        float value = decp1.floatValue();
        dOut.write(22);
        dOut.writeDouble(value /= floatp2.floatValue());
    }

    @Override
    public void operateDecimalInteger(XSDecimalPointable decp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        if (longp2.getLong() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        this.abvsInner.reset();
        this.decp2.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp2.setDecimal(longp2.longValue(), (byte)0);
        this.operateDecimalDecimal(decp1, this.decp2, dOut);
    }

    @Override
    public void operateDecimalYMDuration(XSDecimalPointable decp1, IntegerPointable intp2, DataOutput dOut) throws SystemException, IOException {
        int value = this.operateDecimalInt(decp1, intp2.intValue());
        dOut.write(19);
        dOut.writeInt(value);
    }

    @Override
    public void operateDoubleDecimal(DoublePointable doublep, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        if (decp.getDecimalValue() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= decp.doubleValue());
    }

    @Override
    public void operateDoubleDouble(DoublePointable doublep, DoublePointable doublep2, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= doublep2.doubleValue());
    }

    @Override
    public void operateDoubleDTDuration(DoublePointable doublep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDoubleFloat(DoublePointable doublep, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= floatp.doubleValue());
    }

    @Override
    public void operateDoubleInteger(DoublePointable doublep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        if (longp.getLong() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= longp.doubleValue());
    }

    @Override
    public void operateDoubleYMDuration(DoublePointable doublep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDTDurationDate(LongPointable longp, XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDTDurationDatetime(LongPointable longp, XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDTDurationDecimal(LongPointable longp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        if (decp.getDecimalValue() == 0L) {
            throw new SystemException(ErrorCode.FODT0002);
        }
        long value = longp.longValue();
        dOut.write(20);
        dOut.writeLong(value /= decp.longValue());
    }

    @Override
    public void operateDTDurationDouble(LongPointable longp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        if (Double.isNaN(doublep.doubleValue())) {
            throw new SystemException(ErrorCode.FOCA0005);
        }
        if (doublep.doubleValue() == 0.0) {
            throw new SystemException(ErrorCode.FODT0002);
        }
        double value = longp.doubleValue();
        dOut.write(20);
        dOut.writeLong((long)(value /= doublep.doubleValue()));
    }

    @Override
    public void operateDTDurationDTDuration(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        double value = longp1.longValue();
        this.abvsInner.reset();
        this.doublep.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength());
        this.doublep.setDouble(value /= (double)longp2.longValue());
        CastToDecimalOperation castToDecmial = new CastToDecimalOperation();
        castToDecmial.convertDouble(this.doublep, dOut);
    }

    @Override
    public void operateDTDurationFloat(LongPointable longp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        if (Float.isNaN(floatp.floatValue())) {
            throw new SystemException(ErrorCode.FOCA0005);
        }
        if (floatp.floatValue() == 0.0f) {
            throw new SystemException(ErrorCode.FODT0002);
        }
        float value = longp.floatValue();
        dOut.write(20);
        dOut.writeLong((long)(value /= (float)floatp.intValue()));
    }

    @Override
    public void operateDTDurationInteger(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        if (longp2.getLong() == 0L) {
            throw new SystemException(ErrorCode.FODT0002);
        }
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value /= longp2.longValue());
    }

    @Override
    public void operateDTDurationTime(LongPointable longp, XSTimePointable timep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateFloatDecimal(FloatPointable floatp1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        if (decp2.getDecimalValue() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        float value = floatp1.floatValue();
        dOut.write(22);
        dOut.writeDouble(value /= decp2.floatValue());
    }

    @Override
    public void operateFloatDouble(FloatPointable floatp1, DoublePointable doublep2, DataOutput dOut) throws SystemException, IOException {
        double value = floatp1.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= doublep2.doubleValue());
    }

    @Override
    public void operateFloatDTDuration(FloatPointable floatp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateFloatFloat(FloatPointable floatp1, FloatPointable floatp2, DataOutput dOut) throws SystemException, IOException {
        float value = floatp1.floatValue();
        dOut.write(22);
        dOut.writeFloat(value /= floatp2.floatValue());
    }

    @Override
    public void operateFloatInteger(FloatPointable floatp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        if (longp2.getLong() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        float value = floatp1.floatValue();
        dOut.write(22);
        dOut.writeFloat(value /= longp2.floatValue());
    }

    @Override
    public void operateFloatYMDuration(FloatPointable floatp1, IntegerPointable intp2, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateIntegerDecimal(LongPointable longp1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        if (decp2.getDecimalValue() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        this.abvsInner.reset();
        this.decp1.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp1.setDecimal(longp1.longValue(), (byte)0);
        this.operateDecimalDecimal(this.decp1, decp2, dOut);
    }

    @Override
    public void operateIntegerDouble(LongPointable longp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = longp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value /= doublep.doubleValue());
    }

    @Override
    public void operateIntegerDTDuration(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateIntegerFloat(LongPointable longp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float value = longp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value /= floatp.floatValue());
    }

    @Override
    public void operateIntegerInteger(LongPointable longp, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        if (longp2.getLong() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        double value = longp.doubleValue();
        this.abvsInner.reset();
        this.doublep.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength());
        this.doublep.setDouble(value /= longp2.doubleValue());
        CastToDecimalOperation castToDecmial = new CastToDecimalOperation();
        castToDecmial.convertDouble(this.doublep, dOut);
    }

    @Override
    public void operateIntegerYMDuration(LongPointable longp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateTimeDTDuration(XSTimePointable timep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateTimeTime(XSTimePointable timep, XSTimePointable timep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateYMDurationDate(IntegerPointable intp, XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateYMDurationDatetime(IntegerPointable intp, XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateYMDurationDecimal(IntegerPointable intp1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        int value = this.operateIntDecimal(intp1.intValue(), decp2);
        dOut.write(19);
        dOut.writeInt(value);
    }

    @Override
    public void operateYMDurationDouble(IntegerPointable intp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = intp.doubleValue();
        dOut.write(19);
        dOut.writeInt((int)(value /= doublep.doubleValue()));
    }

    @Override
    public void operateYMDurationFloat(IntegerPointable intp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float value = intp.floatValue();
        dOut.write(19);
        dOut.writeInt((int)(value /= floatp.floatValue()));
    }

    @Override
    public void operateYMDurationInteger(IntegerPointable intp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        if (longp.getLong() == 0L) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value /= longp.intValue());
    }

    @Override
    public void operateYMDurationYMDuration(IntegerPointable intp, IntegerPointable intp2, DataOutput dOut) throws SystemException, IOException {
        if (intp2.getInteger() == 0) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        double value = intp.intValue();
        this.abvsInner.reset();
        this.doublep.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength());
        this.doublep.setDouble(value /= (double)intp2.intValue());
        CastToDecimalOperation castToDecmial = new CastToDecimalOperation();
        castToDecmial.convertDouble(this.doublep, dOut);
    }

    public int operateIntDecimal(int intValue, XSDecimalPointable decp2) throws SystemException, IOException {
        this.abvsInner.reset();
        double value1 = intValue;
        double value2 = decp2.doubleValue();
        if (value2 == 0.0) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        return (int)(value1 /= value2);
    }

    public int operateDecimalInt(XSDecimalPointable decp1, int intValue) throws SystemException, IOException {
        this.abvsInner.reset();
        double value1 = decp1.doubleValue();
        double value2 = intValue;
        if (value2 == 0.0) {
            throw new SystemException(ErrorCode.FOAR0001);
        }
        return (int)(value1 /= value2);
    }
}

