/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.arithmetic;

import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.arithmetic.AbstractArithmeticOperation;

public class AddOperation
extends AbstractArithmeticOperation {
    protected final ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
    protected final DataOutput dOutInner = this.abvsInner.getDataOutput();
    private XSDecimalPointable decp1 = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
    private XSDecimalPointable decp2 = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
    private XSDateTimePointable datetimep1 = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();

    @Override
    public void operateDateDate(XSDatePointable datep, XSDatePointable datep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDateDTDuration(XSDatePointable datep1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        DateTime.normalizeDateTime(datep1.getYearMonth(), datep1.getDayTime() + longp2.getLong(), datep1.getTimezoneHour(), datep1.getTimezoneMinute(), this.dOutInner);
        byte[] bytes = this.abvsInner.getByteArray();
        int startOffset = this.abvsInner.getStartOffset() + 1;
        bytes[startOffset + 4] = bytes[startOffset + 10];
        bytes[startOffset + 5] = bytes[startOffset + 11];
        dOut.write(16);
        dOut.write(bytes, startOffset, XSDatePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDatetimeDatetime(XSDateTimePointable datetimep, XSDateTimePointable datetimep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDatetimeDTDuration(XSDateTimePointable datetimep1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        DateTime.normalizeDateTime(datetimep1.getYearMonth(), datetimep1.getDayTime() + longp2.getLong(), datetimep1.getTimezoneHour(), datetimep1.getTimezoneMinute(), this.dOutInner);
        dOut.write(15);
        dOut.write(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, XSDateTimePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDatetimeYMDuration(XSDateTimePointable datetimep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        DateTime.normalizeDateTime(datetimep.getYearMonth() + (long)intp.getInteger(), datetimep.getDayTime(), datetimep.getTimezoneHour(), datetimep.getTimezoneMinute(), this.dOutInner);
        dOut.write(15);
        dOut.write(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, XSDateTimePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDateYMDuration(XSDatePointable datep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        DateTime.normalizeDateTime(datep.getYearMonth() + (long)intp.getInteger(), datep.getDayTime(), datep.getTimezoneHour(), datep.getTimezoneMinute(), this.dOutInner);
        byte[] bytes = this.abvsInner.getByteArray();
        int startOffset = this.abvsInner.getStartOffset() + 1;
        bytes[startOffset + 4] = bytes[startOffset + 10];
        bytes[startOffset + 5] = bytes[startOffset + 11];
        dOut.write(16);
        dOut.write(bytes, startOffset, XSDatePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDecimalDecimal(XSDecimalPointable decp1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        long value1 = decp1.getDecimalValue();
        long value2 = decp2.getDecimalValue();
        byte place1 = decp1.getDecimalPlace();
        byte place2 = decp2.getDecimalPlace();
        byte count1 = decp1.getDigitCount();
        byte count2 = decp2.getDigitCount();
        while (place1 > place2) {
            place2 = (byte)(place2 + 1);
            value2 *= 10L;
            count2 = (byte)(count2 + 1);
        }
        while (place1 < place2) {
            place1 = (byte)(place1 + 1);
            value1 *= 10L;
            count1 = (byte)(count1 + 1);
        }
        if (count1 > 18 || count2 > 18) {
            throw new SystemException(ErrorCode.XPDY0002);
        }
        dOut.write(24);
        dOut.writeByte(place1);
        dOut.writeLong(value1 += value2);
    }

    @Override
    public void operateDecimalDouble(XSDecimalPointable decp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = decp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value += doublep.doubleValue());
    }

    @Override
    public void operateDecimalDTDuration(XSDecimalPointable decp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        long value = this.operateLongDecimal(longp.longValue(), decp);
        dOut.write(20);
        dOut.writeLong(value);
    }

    @Override
    public void operateDecimalFloat(XSDecimalPointable decp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float value = decp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value += floatp.floatValue());
    }

    @Override
    public void operateDecimalInteger(XSDecimalPointable decp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        this.decp2.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp2.setDecimal(longp2.longValue(), (byte)0);
        this.operateDecimalDecimal(decp1, this.decp2, dOut);
    }

    @Override
    public void operateDecimalYMDuration(XSDecimalPointable decp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = (int)this.operateLongDecimal(intp.intValue(), decp);
        dOut.write(19);
        dOut.writeInt(value);
    }

    @Override
    public void operateDoubleDecimal(DoublePointable doublep1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        this.operateDecimalDouble(decp2, doublep1, dOut);
    }

    @Override
    public void operateDoubleDouble(DoublePointable doublep1, DoublePointable doublep2, DataOutput dOut) throws SystemException, IOException {
        double value = doublep1.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value += doublep2.doubleValue());
    }

    @Override
    public void operateDoubleDTDuration(DoublePointable doublep1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.operateDTDurationDouble(longp2, doublep1, dOut);
    }

    @Override
    public void operateDoubleFloat(DoublePointable doublep, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value += floatp.doubleValue());
    }

    @Override
    public void operateDoubleInteger(DoublePointable doublep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value += longp.doubleValue());
    }

    @Override
    public void operateDoubleYMDuration(DoublePointable doublep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = doublep.intValue();
        dOut.write(19);
        dOut.writeInt(value += intp.intValue());
    }

    @Override
    public void operateDTDurationDate(LongPointable longp, XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.operateDateDTDuration(datep, longp, dOut);
    }

    @Override
    public void operateDTDurationDatetime(LongPointable longp, XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        this.operateDatetimeDTDuration(datetimep, longp, dOut);
    }

    @Override
    public void operateDTDurationDecimal(LongPointable longp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        this.operateDecimalDTDuration(decp, longp, dOut);
    }

    @Override
    public void operateDTDurationDouble(LongPointable longp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        long value = longp.longValue();
        dOut.write(20);
        dOut.writeLong(value += doublep.longValue());
    }

    @Override
    public void operateDTDurationDTDuration(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value += longp2.longValue());
    }

    @Override
    public void operateDTDurationFloat(LongPointable longp1, FloatPointable floatp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value += floatp2.longValue());
    }

    @Override
    public void operateDTDurationInteger(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value += longp2.longValue());
    }

    @Override
    public void operateDTDurationTime(LongPointable longp1, XSTimePointable timep2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        this.datetimep1.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        this.datetimep1.setDateTime(1972L, 12L, 31L, timep2.getHour(), timep2.getMinute(), timep2.getMilliSecond(), timep2.getTimezoneHour(), timep2.getTimezoneMinute());
        DateTime.normalizeDateTime(this.datetimep1.getYearMonth(), this.datetimep1.getDayTime() + longp1.getLong(), timep2.getTimezoneHour(), timep2.getTimezoneMinute(), this.dOutInner);
        int startOffset = this.abvsInner.getStartOffset() + 1 + 4;
        dOut.write(17);
        dOut.write(this.abvsInner.getByteArray(), startOffset, XSTimePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateFloatDecimal(FloatPointable floatp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        this.operateDecimalFloat(decp, floatp, dOut);
    }

    @Override
    public void operateFloatDouble(FloatPointable floatp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        this.operateDoubleFloat(doublep, floatp, dOut);
    }

    @Override
    public void operateFloatDTDuration(FloatPointable floatp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.operateDTDurationFloat(longp, floatp, dOut);
    }

    @Override
    public void operateFloatFloat(FloatPointable floatp, FloatPointable floatp2, DataOutput dOut) throws SystemException, IOException {
        float value = floatp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value += floatp2.floatValue());
    }

    @Override
    public void operateFloatInteger(FloatPointable floatp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        float value = floatp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value += longp.floatValue());
    }

    @Override
    public void operateFloatYMDuration(FloatPointable floatp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.operateYMDurationFloat(intp, floatp, dOut);
    }

    @Override
    public void operateIntegerDecimal(LongPointable longp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        this.operateDecimalInteger(decp, longp, dOut);
    }

    @Override
    public void operateIntegerDouble(LongPointable longp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        this.operateDoubleInteger(doublep, longp, dOut);
    }

    @Override
    public void operateIntegerDTDuration(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.operateDTDurationInteger(longp2, longp1, dOut);
    }

    @Override
    public void operateIntegerFloat(LongPointable longp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        this.operateFloatInteger(floatp, longp, dOut);
    }

    @Override
    public void operateIntegerInteger(LongPointable longp, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp.getLong();
        dOut.write(25);
        dOut.writeLong(value += longp2.getLong());
    }

    @Override
    public void operateIntegerYMDuration(LongPointable longp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = longp.intValue();
        dOut.write(19);
        dOut.writeInt(value += intp.intValue());
    }

    @Override
    public void operateTimeDTDuration(XSTimePointable timep1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.operateDTDurationTime(longp2, timep1, dOut);
    }

    @Override
    public void operateTimeTime(XSTimePointable timep, XSTimePointable timep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateYMDurationDate(IntegerPointable intp, XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.operateDateYMDuration(datep, intp, dOut);
    }

    @Override
    public void operateYMDurationDatetime(IntegerPointable intp, XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        this.operateDatetimeYMDuration(datetimep, intp, dOut);
    }

    @Override
    public void operateYMDurationDecimal(IntegerPointable intp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        this.operateDecimalYMDuration(decp, intp, dOut);
    }

    @Override
    public void operateYMDurationDouble(IntegerPointable intp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        this.operateDoubleYMDuration(doublep, intp, dOut);
    }

    @Override
    public void operateYMDurationFloat(IntegerPointable intp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        this.operateFloatYMDuration(floatp, intp, dOut);
    }

    @Override
    public void operateYMDurationInteger(IntegerPointable intp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.operateIntegerYMDuration(longp, intp, dOut);
    }

    @Override
    public void operateYMDurationYMDuration(IntegerPointable intp, IntegerPointable intp2, DataOutput dOut) throws SystemException, IOException {
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value += intp2.intValue());
    }

    public long operateLongDecimal(long longValue, XSDecimalPointable decp2) throws SystemException, IOException {
        this.abvsInner.reset();
        this.decp1.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp1.setDecimal(longValue, (byte)0);
        long value1 = this.decp1.getDecimalValue();
        long value2 = decp2.getDecimalValue();
        byte place1 = this.decp1.getDecimalPlace();
        byte place2 = decp2.getDecimalPlace();
        byte count1 = this.decp1.getDigitCount();
        byte count2 = decp2.getDigitCount();
        while (place1 > place2) {
            place2 = (byte)(place2 + 1);
            value2 *= 10L;
            count2 = (byte)(count2 + 1);
        }
        while (place1 < place2) {
            place1 = (byte)(place1 + 1);
            value1 *= 10L;
            count1 = (byte)(count1 + 1);
        }
        if (count1 > 18 || count2 > 18) {
            throw new SystemException(ErrorCode.XPDY0002);
        }
        decp2.setDecimal(value1 += value2, place1);
        return decp2.longValue();
    }
}

