/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.aggregate;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.arithmetic.AddOperation;
import org.apache.vxquery.runtime.functions.arithmetic.DivideOperation;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluatorFactory;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class FnAvgAggregateEvaluatorFactory
extends AbstractTaggedValueArgumentAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnAvgAggregateEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IAggregateEvaluator createEvaluator(IScalarEvaluator[] args) throws AlgebricksException {
        final TaggedValuePointable tvpCount = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvsSum = new ArrayBackedValueStorage();
        final DataOutput dOutSum = abvsSum.getDataOutput();
        final ArrayBackedValueStorage abvsCount = new ArrayBackedValueStorage();
        final DataOutput dOutCount = abvsCount.getDataOutput();
        final AddOperation aOp = new AddOperation();
        final DivideOperation aOpDivide = new DivideOperation();
        return new AbstractTaggedValueArgumentAggregateEvaluator(args){
            long count;
            TaggedValuePointable tvpSum;
            {
                super(x0);
                this.tvpSum = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
            }

            public void init() throws AlgebricksException {
                this.count = 0L;
            }

            public void finish(IPointable result) throws AlgebricksException {
                if (this.count == 0L) {
                    XDMConstants.setEmptySequence(result);
                } else {
                    try {
                        abvsCount.reset();
                        dOutCount.write(25);
                        dOutCount.writeLong(this.count);
                        tvpCount.set((IValueReference)abvsCount);
                        FunctionHelper.arithmeticOperation(aOpDivide, AbstractTaggedValueArgumentAggregateEvaluatorFactory.dCtx, this.tvpSum, tvpCount, (IPointable)this.tvpSum);
                        result.set((IValueReference)this.tvpSum);
                    }
                    catch (Exception e) {
                        throw new AlgebricksException((Throwable)e);
                    }
                }
            }

            @Override
            protected void step(TaggedValuePointable[] args) throws SystemException {
                TaggedValuePointable tvp = args[0];
                if (this.count == 0L) {
                    try {
                        abvsSum.reset();
                        dOutSum.write(tvp.getByteArray(), tvp.getStartOffset(), tvp.getLength());
                        this.tvpSum.set((IValueReference)abvsSum);
                    }
                    catch (IOException e) {
                        throw new SystemException(ErrorCode.SYSE0001, e.toString());
                    }
                } else {
                    FunctionHelper.arithmeticOperation(aOp, AbstractTaggedValueArgumentAggregateEvaluatorFactory.dCtx, tvp, this.tvpSum, (IPointable)this.tvpSum);
                }
                ++this.count;
            }
        };
    }
}

