/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.aggregate;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.arithmetic.AddOperation;
import org.apache.vxquery.runtime.functions.arithmetic.DivideOperation;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluatorFactory;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class AvgGlobalAggregateEvaluatorFactory
extends AbstractTaggedValueArgumentAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public AvgGlobalAggregateEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IAggregateEvaluator createEvaluator(IScalarEvaluator[] args) throws AlgebricksException {
        final ArrayBackedValueStorage abvsCount = new ArrayBackedValueStorage();
        final DataOutput dOutCount = abvsCount.getDataOutput();
        final ArrayBackedValueStorage abvsSum = new ArrayBackedValueStorage();
        final DataOutput dOutSum = abvsSum.getDataOutput();
        final AddOperation aOp = new AddOperation();
        final DivideOperation aOpDivide = new DivideOperation();
        final LongPointable longp = (LongPointable)LongPointable.FACTORY.createPointable();
        final SequencePointable seq = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final TaggedValuePointable tvpArg = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        return new AbstractTaggedValueArgumentAggregateEvaluator(args){
            TaggedValuePointable tvpSum;
            TaggedValuePointable tvpCount;
            {
                super(x0);
                this.tvpSum = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
                this.tvpCount = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
            }

            public void init() throws AlgebricksException {
                try {
                    abvsCount.reset();
                    dOutCount.write(25);
                    dOutCount.writeLong(0L);
                    this.tvpCount.set((IValueReference)abvsCount);
                    abvsSum.reset();
                    dOutSum.write(25);
                    dOutSum.writeLong(0L);
                    this.tvpSum.set((IValueReference)abvsSum);
                }
                catch (Exception e) {
                    throw new AlgebricksException((Throwable)e);
                }
            }

            public void finish(IPointable result) throws AlgebricksException {
                this.tvpCount.getValue((IPointable)longp);
                if (longp.getLong() == 0L) {
                    XDMConstants.setEmptySequence(result);
                } else {
                    try {
                        FunctionHelper.arithmeticOperation(aOpDivide, AbstractTaggedValueArgumentAggregateEvaluatorFactory.dCtx, this.tvpSum, this.tvpCount, (IPointable)this.tvpSum);
                        result.set((IValueReference)this.tvpSum);
                    }
                    catch (Exception e) {
                        throw new AlgebricksException((Throwable)e);
                    }
                }
            }

            @Override
            protected void step(TaggedValuePointable[] args) throws SystemException {
                TaggedValuePointable tvp = args[0];
                if (tvp.getTag() == 100) {
                    tvp.getValue((IPointable)seq);
                    int seqLen = seq.getEntryCount();
                    if (seqLen == 0) {
                        return;
                    }
                    if (seqLen == 2) {
                        seq.getEntry(0, (IPointable)tvpArg);
                        FunctionHelper.arithmeticOperation(aOp, AbstractTaggedValueArgumentAggregateEvaluatorFactory.dCtx, tvpArg, this.tvpCount, (IPointable)this.tvpCount);
                        seq.getEntry(1, (IPointable)tvpArg);
                        FunctionHelper.arithmeticOperation(aOp, AbstractTaggedValueArgumentAggregateEvaluatorFactory.dCtx, tvpArg, this.tvpSum, (IPointable)this.tvpSum);
                    } else {
                        throw new SystemException(ErrorCode.SYSE0001);
                    }
                }
            }
        };
    }
}

