/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.aggregate;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluatorFactory;
import org.apache.vxquery.runtime.functions.comparison.AbstractValueComparisonOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public abstract class AbstractMaxMinAggregateEvaluatorFactory
extends AbstractTaggedValueArgumentAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public AbstractMaxMinAggregateEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IAggregateEvaluator createEvaluator(IScalarEvaluator[] args) throws AlgebricksException {
        final AbstractValueComparisonOperation aOp = this.createValueComparisonOperation();
        final TaggedValuePointable tvp2 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final DataOutput dOut = abvs.getDataOutput();
        return new AbstractTaggedValueArgumentAggregateEvaluator(args){
            long count;

            public void init() throws AlgebricksException {
                this.count = 0L;
            }

            public void finish(IPointable result) throws AlgebricksException {
                if (this.count == 0L) {
                    XDMConstants.setEmptySequence(result);
                } else {
                    result.set((IValueReference)abvs);
                }
            }

            @Override
            protected void step(TaggedValuePointable[] args) throws SystemException {
                TaggedValuePointable tvp1 = args[0];
                if (tvp1.getTag() == 100) {
                    tvp1.getValue((IPointable)seqp);
                    int seqLen = seqp.getEntryCount();
                    if (seqLen != 0) {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                } else {
                    if (this.count != 0L) {
                        tvp2.set(abvs.getByteArray(), abvs.getStartOffset(), abvs.getLength());
                    }
                    if (this.count == 0L || FunctionHelper.transformThenCompareMinMaxTaggedValues(aOp, tvp1, tvp2, AbstractTaggedValueArgumentAggregateEvaluatorFactory.dCtx)) {
                        try {
                            abvs.reset();
                            dOut.write(tvp1.getByteArray(), tvp1.getStartOffset(), tvp1.getLength());
                        }
                        catch (IOException e) {
                            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                        }
                    }
                    ++this.count;
                }
            }
        };
    }

    protected abstract AbstractValueComparisonOperation createValueComparisonOperation();
}

