/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.metadata;

import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSink;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSource;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.data.IAWriterFactory;
import edu.uci.ics.hyracks.algebricks.data.IPrinterFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import edu.uci.ics.hyracks.algebricks.runtime.serializer.ResultSerializerFactoryProvider;
import edu.uci.ics.hyracks.algebricks.runtime.writers.PrinterBasedWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.value.IResultSerializerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.dataflow.std.result.ResultWriterOperatorDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.vxquery.metadata.QueryResultSetDataSink;
import org.apache.vxquery.metadata.VXQueryCollectionDataSource;
import org.apache.vxquery.metadata.VXQueryCollectionOperatorDescriptor;

public class VXQueryMetadataProvider
implements IMetadataProvider<String, String> {
    String[] nodeList;
    Map<String, File> sourceFileMap;

    public VXQueryMetadataProvider(String[] nodeList, Map<String, File> sourceFileMap) {
        this.nodeList = nodeList;
        this.sourceFileMap = sourceFileMap;
    }

    public IDataSource<String> findDataSource(String id) throws AlgebricksException {
        return null;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getScannerRuntime(IDataSource<String> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig) throws AlgebricksException {
        VXQueryCollectionDataSource ds = (VXQueryCollectionDataSource)dataSource;
        if (this.sourceFileMap != null) {
            int len = ds.getPartitions().length;
            String[] collectionPartitions = new String[len];
            for (int i = 0; i < len; ++i) {
                String partition = ds.getPartitions()[i];
                File mapped = this.sourceFileMap.get(partition);
                collectionPartitions[i] = mapped != null ? mapped.toString() : partition;
            }
            ds.setPartitions(collectionPartitions);
        }
        RecordDescriptor rDesc = new RecordDescriptor(new ISerializerDeserializer[opSchema.getSize()]);
        VXQueryCollectionOperatorDescriptor scanner = new VXQueryCollectionOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, ds, rDesc);
        AlgebricksPartitionConstraint constraint = VXQueryMetadataProvider.getClusterLocations(this.nodeList, ds.getPartitionCount());
        return new Pair((Object)scanner, (Object)constraint);
    }

    public static AlgebricksPartitionConstraint getClusterLocations(String[] nodeList) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (availableProcessors < 1) {
            availableProcessors = 1;
        }
        return VXQueryMetadataProvider.getClusterLocations(nodeList, availableProcessors);
    }

    public static AlgebricksPartitionConstraint getClusterLocations(String[] nodeList, int partitions) {
        ArrayList<String> locs = new ArrayList<String>();
        for (String node : nodeList) {
            for (int j = 0; j < partitions; ++j) {
                locs.add(node);
            }
        }
        String[] cluster = new String[locs.size()];
        cluster = locs.toArray(cluster);
        return new AlgebricksAbsolutePartitionConstraint(cluster);
    }

    public boolean scannerOperatorIsLeaf(IDataSource<String> dataSource) {
        return false;
    }

    public Pair<IPushRuntimeFactory, AlgebricksPartitionConstraint> getWriteFileRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc) throws AlgebricksException {
        return null;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getWriteResultRuntime(IDataSource<String> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payLoadVar, JobGenContext context, JobSpecification jobSpec) throws AlgebricksException {
        return null;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertRuntime(IDataSource<String> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payLoadVar, RecordDescriptor recordDesc, JobGenContext context, JobSpecification jobSpec) throws AlgebricksException {
        return null;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getDeleteRuntime(IDataSource<String> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payLoadVar, RecordDescriptor recordDesc, JobGenContext context, JobSpecification jobSpec) throws AlgebricksException {
        return null;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertRuntime(IDataSourceIndex<String, String> dataSource, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return null;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexDeleteRuntime(IDataSourceIndex<String, String> dataSource, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return null;
    }

    public IDataSourceIndex<String, String> findDataSourceIndex(String indexId, String dataSourceId) throws AlgebricksException {
        return null;
    }

    public IFunctionInfo lookupFunction(final FunctionIdentifier fid) {
        return new IFunctionInfo(){

            public FunctionIdentifier getFunctionIdentifier() {
                return fid;
            }

            public boolean isFunctional() {
                return true;
            }
        };
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getResultHandleRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc, boolean ordered, JobSpecification spec) throws AlgebricksException {
        QueryResultSetDataSink rsds = (QueryResultSetDataSink)sink;
        ResultSetId rssId = rsds.getId();
        ResultSerializerFactoryProvider resultSerializerFactoryProvider = ResultSerializerFactoryProvider.INSTANCE;
        PrinterBasedWriterFactory writerFactory = PrinterBasedWriterFactory.INSTANCE;
        ResultWriterOperatorDescriptor resultWriter = null;
        try {
            IResultSerializerFactory resultSerializedAppenderFactory = resultSerializerFactoryProvider.getAqlResultSerializerFactoryProvider(printColumns, printerFactories, (IAWriterFactory)writerFactory);
            resultWriter = new ResultWriterOperatorDescriptor((IOperatorDescriptorRegistry)spec, rssId, ordered, false, resultSerializedAppenderFactory);
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)resultWriter, null);
    }
}

