/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.metadata;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.vxquery.datamodel.accessors.PointablePool;
import org.apache.vxquery.datamodel.accessors.PointablePoolFactory;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.metadata.VXQueryCollectionDataSource;
import org.apache.vxquery.metadata.VXQueryIOFileFilter;
import org.apache.vxquery.runtime.functions.step.ChildPathStepOperatorDescriptor;
import org.apache.vxquery.xmlparser.TreeNodeIdProvider;
import org.apache.vxquery.xmlparser.XMLParser;
import org.xml.sax.InputSource;

public class VXQueryCollectionOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private short dataSourceId;
    private short totalDataSources;
    private String[] collectionPartitions;
    private List<Integer> childSeq;

    public VXQueryCollectionOperatorDescriptor(IOperatorDescriptorRegistry spec, VXQueryCollectionDataSource ds, RecordDescriptor rDesc) {
        super(spec, 1, 1);
        this.collectionPartitions = ds.getPartitions();
        this.dataSourceId = (short)ds.getDataSourceId();
        this.totalDataSources = (short)ds.getTotalDataSources();
        this.childSeq = ds.getChildSeq();
        this.recordDescriptors[0] = rDesc;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FrameTupleAccessor fta = new FrameTupleAccessor(ctx.getFrameSize(), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
        int fieldOutputCount = recordDescProvider.getOutputRecordDescriptor(this.getActivityId(), 0).getFieldCount();
        final ByteBuffer frame = ctx.allocateFrame();
        final FrameTupleAppender appender = new FrameTupleAppender(ctx.getFrameSize(), fieldOutputCount);
        final InputSource in = new InputSource();
        final ArrayBackedValueStorage abvsFileNode = new ArrayBackedValueStorage();
        short partitionId = (short)ctx.getTaskAttemptId().getTaskId().getPartition();
        TreeNodeIdProvider nodeIdProvider = new TreeNodeIdProvider(partitionId, this.dataSourceId, this.totalDataSources);
        final String nodeId = ctx.getJobletContext().getApplicationContext().getNodeId();
        final int frameSize = ctx.getFrameSize();
        final PointablePool ppool = PointablePoolFactory.INSTANCE.createPointablePool();
        final ChildPathStepOperatorDescriptor childPathStep = new ChildPathStepOperatorDescriptor(ctx, ppool);
        final String collectionName = this.collectionPartitions[partition % this.collectionPartitions.length];
        final XMLParser parser = new XMLParser(false, nodeIdProvider);
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){

            public void open() throws HyracksDataException {
                appender.reset(frame, true);
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                fta.reset(buffer);
                String collectionModifiedName = collectionName.replace("${nodeId}", nodeId);
                File collectionDirectory = new File(collectionModifiedName);
                if (collectionDirectory.isDirectory()) {
                    for (int t = 0; t < fta.getTupleCount(); ++t) {
                        Iterator it = FileUtils.iterateFiles((File)collectionDirectory, (IOFileFilter)new VXQueryIOFileFilter(), (IOFileFilter)TrueFileFilter.INSTANCE);
                        while (it.hasNext()) {
                            this.addNextXmlNode((File)it.next(), t);
                        }
                    }
                } else {
                    throw new HyracksDataException("Invalid directory parameter passed to collection (VXQueryCollectionOperatorDescriptor.nextFrame).");
                }
            }

            private void addNextXmlNode(File file, int t) throws HyracksDataException {
                abvsFileNode.reset();
                try {
                    parser.parseFile(file, in, abvsFileNode);
                }
                catch (HyracksDataException e) {
                    e.setNodeId(nodeId);
                    throw e;
                }
                TaggedValuePointable tvp = ppool.takeOne(TaggedValuePointable.class);
                if (VXQueryCollectionOperatorDescriptor.this.childSeq.isEmpty()) {
                    if (frameSize <= abvsFileNode.getLength() - abvsFileNode.getStartOffset()) {
                        throw new HyracksDataException("XML node is to large for the current frame size (VXQueryCollectionOperatorDescriptor.addXmlFile).");
                    }
                    tvp.set(abvsFileNode.getByteArray(), abvsFileNode.getStartOffset(), abvsFileNode.getLength());
                    this.addNodeToTuple(tvp, t);
                } else {
                    tvp.set(abvsFileNode.getByteArray(), abvsFileNode.getStartOffset(), abvsFileNode.getLength());
                    this.processChildStep(tvp, t);
                }
                ppool.giveBack(tvp);
            }

            private void processChildStep(TaggedValuePointable tvp, int t) throws HyracksDataException {
                try {
                    childPathStep.init(tvp, VXQueryCollectionOperatorDescriptor.this.childSeq);
                }
                catch (SystemException e) {
                    throw new HyracksDataException("Child path step failed to load node tree.");
                }
                try {
                    TaggedValuePointable result = ppool.takeOne(TaggedValuePointable.class);
                    while (childPathStep.step((IPointable)result)) {
                        this.addNodeToTuple(result, t);
                    }
                    ppool.giveBack(result);
                }
                catch (AlgebricksException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            private void addNodeToTuple(TaggedValuePointable result, int t) throws HyracksDataException {
                if (!this.addNodeToTupleAppender(result, t)) {
                    FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)this.writer);
                    appender.reset(frame, true);
                    if (!this.addNodeToTupleAppender(result, t)) {
                        throw new HyracksDataException("Could not write frame (VXQueryCollectionOperatorDescriptor.createPushRuntime).");
                    }
                }
            }

            private boolean addNodeToTupleAppender(TaggedValuePointable result, int t) throws HyracksDataException {
                if (fta.getFieldCount() > 0) {
                    for (int f = 0; f < fta.getFieldCount(); ++f) {
                        if (appender.appendField((IFrameTupleAccessor)fta, t, f)) continue;
                        return false;
                    }
                }
                return appender.appendField(result.getByteArray(), result.getStartOffset(), result.getLength());
            }

            public void fail() throws HyracksDataException {
                this.writer.fail();
            }

            public void close() throws HyracksDataException {
                fta.reset(frame);
                if (fta.getTupleCount() > 0) {
                    FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)this.writer);
                }
                this.writer.close();
            }
        };
    }
}

