/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.functions;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.vxquery.types.SequenceType;

public final class Signature {
    private QName[] parameterNames;
    private boolean varArgs;
    private SequenceType[] parameterTypes;
    private SequenceType rType;

    public Signature(SequenceType rType, Pair<QName, SequenceType> ... parameters) {
        this(rType, false, parameters);
    }

    public Signature(SequenceType rType, boolean varArgs, Pair<QName, SequenceType> ... parameters) {
        int len = parameters.length;
        this.varArgs = varArgs;
        this.parameterNames = new QName[len];
        this.parameterTypes = new SequenceType[len];
        for (int i = 0; i < parameters.length; ++i) {
            this.parameterNames[i] = (QName)parameters[i].getLeft();
            this.parameterTypes[i] = (SequenceType)parameters[i].getRight();
        }
        this.rType = rType;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public int getArity() {
        return this.parameterTypes.length;
    }

    public SequenceType getParameterType(int index) {
        if (this.varArgs && this.parameterTypes.length <= index) {
            return this.parameterTypes[this.parameterTypes.length - 1];
        }
        return this.parameterTypes[index];
    }

    public QName getParameterName(int index) {
        if (this.varArgs && this.parameterNames.length <= index) {
            return this.parameterNames[this.parameterNames.length - 1];
        }
        return this.parameterNames[index];
    }

    public SequenceType getReturnType() {
        return this.rType;
    }

    public void serialize(StringBuffer buffer) {
    }
}

