/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.values;

import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.IOException;
import java.util.Arrays;
import org.apache.vxquery.datamodel.builders.sequence.SequenceBuilder;

public class XDMConstants {
    private static final byte[] BOOLEAN_TRUE_CONSTANT = new byte[2];
    private static final byte[] BOOLEAN_FALSE_CONSTANT;
    private static final byte[] EMPTY_SEQUENCE;
    private static final byte[] EMPTY_STRING;

    public static void setTrue(IPointable p) {
        XDMConstants.set(p, BOOLEAN_TRUE_CONSTANT);
    }

    public static void setFalse(IPointable p) {
        XDMConstants.set(p, BOOLEAN_FALSE_CONSTANT);
    }

    public static void setEmptySequence(IPointable p) {
        XDMConstants.set(p, EMPTY_SEQUENCE);
    }

    public static void setEmptyString(IPointable p) {
        XDMConstants.set(p, EMPTY_STRING);
    }

    private static void set(IPointable p, byte[] array) {
        p.set(array, 0, array.length);
    }

    private XDMConstants() {
    }

    static {
        XDMConstants.BOOLEAN_TRUE_CONSTANT[0] = 43;
        BooleanPointable.setBoolean((byte[])BOOLEAN_TRUE_CONSTANT, (int)1, (boolean)true);
        BOOLEAN_FALSE_CONSTANT = new byte[2];
        XDMConstants.BOOLEAN_FALSE_CONSTANT[0] = 43;
        BooleanPointable.setBoolean((byte[])BOOLEAN_FALSE_CONSTANT, (int)1, (boolean)false);
        ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        SequenceBuilder sb = new SequenceBuilder();
        sb.reset((IMutableValueStorage)abvs);
        try {
            sb.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        EMPTY_SEQUENCE = Arrays.copyOf(abvs.getByteArray(), abvs.getLength());
        EMPTY_STRING = new byte[3];
        XDMConstants.EMPTY_STRING[0] = 4;
        XDMConstants.EMPTY_STRING[1] = 0;
        XDMConstants.EMPTY_STRING[2] = 0;
    }
}

