/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.util;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.api.ITimezone;

public class DateTime {
    public static final long[] DAYS_OF_MONTH_ORDI = new long[]{31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
    public static final long[] DAYS_OF_MONTH_LEAP = new long[]{31L, 29L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
    public static final long CHRONON_OF_SECOND = 1000L;
    public static final long CHRONON_OF_MINUTE = 60000L;
    public static final long CHRONON_OF_HOUR = 3600000L;
    public static final long CHRONON_OF_DAY = 86400000L;
    public static final int[] FIELD_MINS = new int[]{Short.MIN_VALUE, 1, 1, 0, 0, 0};
    public static final int[] FIELD_MAXS = new int[]{Short.MAX_VALUE, 12, 31, 23, 59, 59999};
    public static final int TIMEZONE_HOUR_MIN = -14;
    public static final int TIMEZONE_HOUR_MAX = 14;
    public static final int TIMEZONE_MINUTE_MIN = -59;
    public static final int TIMEZONE_MINUTE_MAX = 59;
    public static final byte TIMEZONE_HOUR_NULL = 127;
    public static final byte TIMEZONE_MINUTE_NULL = 127;
    public static final int YEAR_FIELD_INDEX = 0;
    public static final int MONTH_FIELD_INDEX = 1;
    public static final int DAY_FIELD_INDEX = 2;
    public static final int HOUR_FIELD_INDEX = 3;
    public static final int MINUTE_FIELD_INDEX = 4;
    public static final int MILLISECOND_FIELD_INDEX = 5;
    public static final int TIME_DEFAULT_YEAR = 1972;
    public static final int TIME_DEFAULT_MONTH = 12;
    public static final int TIME_DEFAULT_DAY = 31;

    public static boolean isLeapYear(long year) {
        return (year & 3L) == 0L && (year % 100L != 0L || year % 400L == 0L);
    }

    public static boolean valid(long year, long month, long day, long hour, long minute, long millisecond, long timezoneHour, long timezoneMinute) {
        if (year > (long)FIELD_MAXS[0] || year < (long)FIELD_MINS[0]) {
            return false;
        }
        long[] monthCheck = DAYS_OF_MONTH_ORDI;
        if (DateTime.isLeapYear(year)) {
            monthCheck = DAYS_OF_MONTH_LEAP;
        }
        if (month > (long)FIELD_MAXS[1] || month < (long)FIELD_MINS[1]) {
            return false;
        }
        if (day > monthCheck[(int)(month - 1L)] || day < (long)FIELD_MINS[2]) {
            return false;
        }
        if (hour > (long)FIELD_MAXS[3] || hour < (long)FIELD_MINS[3]) {
            return false;
        }
        if (minute > (long)FIELD_MAXS[4] || minute < (long)FIELD_MINS[4]) {
            return false;
        }
        if (millisecond > (long)FIELD_MAXS[5] || millisecond < (long)FIELD_MINS[5]) {
            return false;
        }
        if ((timezoneHour > 14L || timezoneHour < -14L) && timezoneHour != 127L) {
            return false;
        }
        return timezoneMinute <= 59L && timezoneMinute >= -59L || timezoneMinute == 127L;
    }

    public static void normalizeDateTime(long yearMonth, long dayTime, long timezoneHour, long timezoneMinute, DataOutput dOut) throws IOException {
        long[] monthDayLimits;
        long day = dayTime / 86400000L;
        long hour = (dayTime %= 86400000L) / 3600000L;
        long minute = (dayTime %= 3600000L) / 60000L;
        long millisecond = dayTime %= 60000L;
        long month = yearMonth % 12L == 0L ? 12L : yearMonth % 12L;
        long year = yearMonth / 12L + (long)(month == 12L ? -1 : 0);
        long[] lArray = monthDayLimits = DateTime.isLeapYear(year) ? DAYS_OF_MONTH_LEAP : DAYS_OF_MONTH_ORDI;
        while (day < (long)FIELD_MINS[2] || day > monthDayLimits[(int)month - 1] || month < (long)FIELD_MINS[1] || month > (long)FIELD_MAXS[1] || hour < (long)FIELD_MINS[3] || hour > (long)FIELD_MAXS[3] || minute < (long)FIELD_MINS[4] || minute > (long)FIELD_MAXS[4] || millisecond < (long)FIELD_MINS[5] || millisecond > (long)FIELD_MAXS[5]) {
            if (millisecond < (long)FIELD_MINS[5]) {
                --minute;
                millisecond += 60000L;
            } else if (millisecond > (long)FIELD_MAXS[5]) {
                ++minute;
                millisecond -= 60000L;
            }
            if (minute < (long)FIELD_MINS[4]) {
                --hour;
                minute += 60L;
            } else if (minute > (long)FIELD_MAXS[4]) {
                ++hour;
                minute -= 60L;
            }
            if (hour < (long)FIELD_MINS[3]) {
                --day;
                hour += 24L;
            } else if (hour > (long)FIELD_MAXS[3]) {
                ++day;
                hour -= 24L;
            }
            if (day < (long)FIELD_MINS[2]) {
                if (--month < (long)FIELD_MINS[1]) {
                    month = FIELD_MAXS[1];
                    --year;
                }
                day += monthDayLimits[(int)month - 1];
            } else if (day > monthDayLimits[(int)month - 1]) {
                day -= monthDayLimits[(int)month - 1];
                ++month;
            }
            if (month < (long)FIELD_MINS[1]) {
                month = FIELD_MAXS[1];
                --year;
            } else if (month > (long)FIELD_MAXS[1]) {
                month = FIELD_MINS[1];
                ++year;
            }
            monthDayLimits = DateTime.isLeapYear(year) ? DAYS_OF_MONTH_LEAP : DAYS_OF_MONTH_ORDI;
        }
        dOut.write(15);
        dOut.writeShort((short)year);
        dOut.writeByte((byte)month);
        dOut.writeByte((byte)day);
        dOut.writeByte((byte)hour);
        dOut.writeByte((byte)minute);
        dOut.writeInt((int)millisecond);
        dOut.writeByte((byte)timezoneHour);
        dOut.writeByte((byte)timezoneMinute);
    }

    public static void getUtcTimezoneDateTime(ITimezone timezonep, ITimezone defaultTimezonep, DataOutput dOut) throws IOException {
        long timezoneMinute;
        long timezoneHour;
        if (timezonep.getTimezoneHour() == 127L || timezonep.getTimezoneMinute() == 127L) {
            timezoneHour = defaultTimezonep.getTimezoneHour();
            timezoneMinute = defaultTimezonep.getTimezoneMinute();
        } else {
            timezoneHour = timezonep.getTimezoneHour();
            timezoneMinute = timezonep.getTimezoneMinute();
        }
        long dayTime = timezonep.getDayTime() - (timezoneHour * 3600000L + timezoneMinute * 60000L);
        DateTime.normalizeDateTime(timezonep.getYearMonth(), dayTime, 0L, 0L, dOut);
    }

    public static void adjustDateTimeToTimezone(ITimezone timezonep, long timezone, DataOutput dOut) throws IOException {
        long timezoneHour = timezone / 60L;
        long timezoneMinute = timezone % 60L;
        long dayTime = timezonep.getDayTime();
        if (timezonep.getTimezoneHour() != 127L && timezonep.getTimezoneMinute() != 127L) {
            dayTime -= timezonep.getTimezoneHour() * 3600000L + timezonep.getTimezoneMinute() * 60000L;
            dayTime += timezoneHour * 3600000L + timezoneMinute * 60000L;
        }
        DateTime.normalizeDateTime(timezonep.getYearMonth(), dayTime, timezoneHour, timezoneMinute, dOut);
    }
}

