/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.builders.sequence;

import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.util.GrowableIntArray;

public class SequenceBuilder {
    private final GrowableIntArray slots = new GrowableIntArray();
    private final ArrayBackedValueStorage dataArea = new ArrayBackedValueStorage();
    private IMutableValueStorage mvs;

    public void reset(IMutableValueStorage mvs) {
        this.mvs = mvs;
        this.slots.clear();
        this.dataArea.reset();
    }

    public void addItem(IValueReference p) throws IOException {
        this.dataArea.getDataOutput().write(p.getByteArray(), p.getStartOffset(), p.getLength());
        this.slots.append(this.dataArea.getLength());
    }

    public void finish() throws IOException {
        DataOutput out = this.mvs.getDataOutput();
        if (this.slots.getSize() != 1) {
            out.write(100);
            int size = this.slots.getSize();
            out.writeInt(size);
            if (size > 0) {
                int[] slotArray = this.slots.getArray();
                for (int i = 0; i < size; ++i) {
                    out.writeInt(slotArray[i]);
                }
                out.write(this.dataArea.getByteArray(), this.dataArea.getStartOffset(), this.dataArea.getLength());
            }
        } else {
            out.write(this.dataArea.getByteArray(), this.dataArea.getStartOffset(), this.dataArea.getLength());
        }
    }
}

