/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.builders.nodes;

import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.builders.nodes.AbstractNodeBuilder;

public class NodeSubTreeBuilder
extends AbstractNodeBuilder {
    private DataOutput mainOut;

    @Override
    public void reset(IMutableValueStorage mvs) throws IOException {
        this.mainOut = mvs.getDataOutput();
        this.mainOut.write(107);
    }

    @Override
    public void finish() throws IOException {
    }

    public void setChildNode(NodeTreePointable ntp, TaggedValuePointable itemTvp) throws IOException {
        boolean hasDictionary = ntp.dictionaryExists() && this.hasDictionary(itemTvp.getTag());
        byte header = (byte)(hasDictionary ? 2 : 0);
        boolean hasNodeIds = ntp.nodeIdExists();
        if (hasNodeIds) {
            header = (byte)(header | 1);
        }
        this.mainOut.write(header);
        if (hasNodeIds) {
            this.mainOut.writeInt(ntp.getRootNodeId());
        }
        if (hasDictionary) {
            this.mainOut.write(ntp.getByteArray(), ntp.getDictionaryOffset(), ntp.getDictionarySize());
        }
        this.mainOut.write(itemTvp.getByteArray(), itemTvp.getStartOffset(), itemTvp.getLength());
    }

    private boolean hasDictionary(byte tag) {
        switch (tag) {
            case 101: 
            case 102: 
            case 103: {
                return true;
            }
        }
        return false;
    }
}

