/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.builders.nodes;

import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.builders.nodes.AbstractNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.AttributeNodeBuilder;
import org.apache.vxquery.util.GrowableIntArray;

public class ElementNodeBuilder
extends AbstractNodeBuilder {
    private final GrowableIntArray attrSlots = new GrowableIntArray();
    private final IMutableValueStorage attrDataArea = new ArrayBackedValueStorage();
    private final GrowableIntArray childrenSlots = new GrowableIntArray();
    private final IMutableValueStorage childrenDataArea = new ArrayBackedValueStorage();
    private IMutableValueStorage mvs;
    private DataOutput out;
    private int headerOffset;
    private int nsChunkStart;
    private int nsCount;
    private int attrCount;
    private int childrenCount;

    @Override
    public void reset(IMutableValueStorage mvs) throws IOException {
        this.mvs = mvs;
        this.out = mvs.getDataOutput();
        this.out.write(102);
        this.headerOffset = mvs.getLength();
        this.out.write(0);
    }

    @Override
    public void finish() throws IOException {
        byte header = 0;
        if (this.nsCount > 0) {
            header = (byte)(header | 1);
        }
        if (this.attrCount > 0) {
            header = (byte)(header | 2);
        }
        if (this.childrenCount > 0) {
            header = (byte)(header | 4);
        }
        BytePointable.setByte((byte[])this.mvs.getByteArray(), (int)this.headerOffset, (byte)header);
    }

    public void setName(int uriCode, int localNameCode, int prefixCode) throws IOException {
        this.out.writeInt(prefixCode);
        this.out.writeInt(uriCode);
        this.out.writeInt(localNameCode);
    }

    public void setType(int uriCode, int localNameCode, int prefixCode) throws IOException {
        this.out.writeInt(prefixCode);
        this.out.writeInt(uriCode);
        this.out.writeInt(localNameCode);
    }

    public void setLocalNodeId(int localNodeId) throws IOException {
        this.out.writeInt(localNodeId);
    }

    public void startNamespaceChunk() {
        this.nsChunkStart = this.mvs.getLength();
        this.nsCount = 0;
    }

    public void addNamespace(int prefixCode, int uriCode) throws IOException {
        if (this.nsCount == 0) {
            this.out.writeInt(0);
        }
        this.out.writeInt(prefixCode);
        this.out.writeInt(uriCode);
        ++this.nsCount;
    }

    public void endNamespaceChunk() {
        byte[] bytes = this.mvs.getByteArray();
        IntegerPointable.setInteger((byte[])bytes, (int)this.nsChunkStart, (int)this.nsCount);
    }

    public void startAttributeChunk() {
        this.attrSlots.clear();
        this.attrDataArea.reset();
    }

    public void startAttribute(AttributeNodeBuilder attrb) throws IOException {
        attrb.reset(this.attrDataArea);
    }

    public void endAttribute(AttributeNodeBuilder attrb) throws IOException {
        attrb.finish();
        this.attrSlots.append(this.attrDataArea.getLength());
    }

    public void endAttributeChunk() throws IOException {
        this.attrCount = this.attrSlots.getSize();
        if (this.attrCount > 0) {
            this.out.writeInt(this.attrCount);
            int[] slotArray = this.attrSlots.getArray();
            for (int i = 0; i < this.attrCount; ++i) {
                int slot = slotArray[i];
                this.out.writeInt(slot);
            }
            this.out.write(this.attrDataArea.getByteArray(), this.attrDataArea.getStartOffset(), this.attrDataArea.getLength());
        }
    }

    public void startChildrenChunk() {
        this.childrenSlots.clear();
        this.childrenDataArea.reset();
    }

    public void startChild(AbstractNodeBuilder nb) throws IOException {
        nb.reset(this.childrenDataArea);
    }

    public void endChild(AbstractNodeBuilder nb) throws IOException {
        nb.finish();
        this.childrenSlots.append(this.childrenDataArea.getLength());
    }

    public void addChild(IValueReference value) throws IOException {
        this.childrenDataArea.getDataOutput().write(value.getByteArray(), value.getStartOffset(), value.getLength());
        this.childrenSlots.append(this.childrenDataArea.getLength());
    }

    public void endChildrenChunk() throws IOException {
        this.childrenCount = this.childrenSlots.getSize();
        if (this.childrenCount > 0) {
            this.out.writeInt(this.childrenCount);
            int[] slotArray = this.childrenSlots.getArray();
            for (int i = 0; i < this.childrenCount; ++i) {
                int slot = slotArray[i];
                this.out.writeInt(slot);
            }
            this.out.write(this.childrenDataArea.getByteArray(), this.childrenDataArea.getStartOffset(), this.childrenDataArea.getLength());
        }
    }
}

