/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.builders.nodes;

import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.builders.nodes.AbstractNodeBuilder;
import org.apache.vxquery.util.GrowableIntArray;

public class DocumentNodeBuilder
extends AbstractNodeBuilder {
    private final GrowableIntArray childrenSlots = new GrowableIntArray();
    private final ArrayBackedValueStorage childrenDataArea = new ArrayBackedValueStorage();
    private DataOutput out;
    private int childrenCount;

    @Override
    public void reset(IMutableValueStorage mvs) throws IOException {
        this.out = mvs.getDataOutput();
        this.out.write(101);
    }

    @Override
    public void finish() throws IOException {
    }

    public void setLocalNodeId(int localNodeId) throws IOException {
        this.out.writeInt(localNodeId);
    }

    public void startChildrenChunk() {
        this.childrenSlots.clear();
        this.childrenDataArea.reset();
    }

    public void startChild(AbstractNodeBuilder nb) throws IOException {
        nb.reset((IMutableValueStorage)this.childrenDataArea);
    }

    public void endChild(AbstractNodeBuilder nb) throws IOException {
        nb.finish();
        this.childrenSlots.append(this.childrenDataArea.getLength());
    }

    public void endChildrenChunk() throws IOException {
        this.childrenCount = this.childrenSlots.getSize();
        if (this.childrenCount > 0) {
            this.out.writeInt(this.childrenCount);
            int[] slotArray = this.childrenSlots.getArray();
            for (int i = 0; i < this.childrenCount; ++i) {
                int slot = slotArray[i];
                this.out.writeInt(slot);
            }
            this.out.write(this.childrenDataArea.getByteArray(), this.childrenDataArea.getStartOffset(), this.childrenDataArea.getLength());
        }
    }
}

