/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.builders.nodes;

import edu.uci.ics.hyracks.data.std.algorithms.BinarySearchAlgorithm;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.collections.api.IValueReferenceVector;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import edu.uci.ics.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.apache.vxquery.util.GrowableIntArray;

public class DictionaryBuilder {
    private final GrowableIntArray stringEndOffsets;
    private final GrowableIntArray sortedSlotIndexes;
    private final ByteArrayAccessibleOutputStream dataBuffer;
    private final DataOutput dataBufferOut;
    private final ByteArrayAccessibleOutputStream tempStringData;
    private final TreeMap<String, Integer> hashSlotIndexes;
    private final IValueReferenceVector sortedStringsVector = new IValueReferenceVector(){

        public int getStart(int index) {
            int slot = DictionaryBuilder.this.sortedSlotIndexes.getArray()[index];
            return slot == 0 ? 0 : DictionaryBuilder.this.stringEndOffsets.getArray()[slot - 1];
        }

        public int getSize() {
            return DictionaryBuilder.this.stringEndOffsets.getSize();
        }

        public int getLength(int index) {
            return UTF8StringPointable.getUTFLength((byte[])DictionaryBuilder.this.dataBuffer.getByteArray(), (int)this.getStart(index)) + 2;
        }

        public byte[] getBytes(int index) {
            return DictionaryBuilder.this.dataBuffer.getByteArray();
        }
    };
    private final BinarySearchAlgorithm binSearch = new BinarySearchAlgorithm();

    public DictionaryBuilder() {
        this.stringEndOffsets = new GrowableIntArray();
        this.sortedSlotIndexes = new GrowableIntArray();
        this.dataBuffer = new ByteArrayAccessibleOutputStream();
        this.dataBufferOut = new DataOutputStream((OutputStream)this.dataBuffer);
        this.tempStringData = new ByteArrayAccessibleOutputStream();
        this.hashSlotIndexes = new TreeMap();
    }

    public void reset() {
        this.stringEndOffsets.clear();
        this.sortedSlotIndexes.clear();
        this.dataBuffer.reset();
        this.tempStringData.reset();
        this.hashSlotIndexes.clear();
    }

    public void write(ArrayBackedValueStorage abvs) throws IOException {
        DataOutput out = abvs.getDataOutput();
        int sizeOffset = abvs.getLength();
        out.writeInt(0);
        int entryCount = this.stringEndOffsets.getSize();
        out.writeInt(entryCount);
        int[] entryOffsets = this.stringEndOffsets.getArray();
        for (int i = 0; i < entryCount; ++i) {
            out.writeInt(entryOffsets[i]);
        }
        if (this.hashSlotIndexes.isEmpty()) {
            int[] sortedOffsets = this.sortedSlotIndexes.getArray();
            for (int i = 0; i < entryCount; ++i) {
                out.writeInt(sortedOffsets[i]);
            }
        } else {
            for (Map.Entry<String, Integer> me : this.hashSlotIndexes.entrySet()) {
                out.writeInt(me.getValue());
            }
        }
        out.write(this.dataBuffer.getByteArray(), 0, this.dataBuffer.size());
        IntegerPointable.setInteger((byte[])abvs.getByteArray(), (int)sizeOffset, (int)(abvs.getLength() - sizeOffset));
    }

    public int lookup(String str) {
        Integer slotIndex = this.hashSlotIndexes.get(str);
        if (slotIndex == null) {
            try {
                this.dataBufferOut.writeUTF(str);
                slotIndex = this.stringEndOffsets.getSize();
                this.dataBufferOut.writeInt(slotIndex);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.stringEndOffsets.append(this.dataBuffer.size());
            this.hashSlotIndexes.put(str, slotIndex);
        }
        return slotIndex;
    }

    public int lookup(UTF8StringPointable str) {
        boolean found = this.binSearch.find(this.sortedStringsVector, (IComparable)str);
        int index = this.binSearch.getIndex();
        if (found) {
            return this.sortedSlotIndexes.getArray()[index];
        }
        this.dataBuffer.write(str.getByteArray(), str.getStartOffset(), str.getLength());
        int slotIndex = this.stringEndOffsets.getSize();
        try {
            this.dataBufferOut.writeInt(slotIndex);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.stringEndOffsets.append(this.dataBuffer.size());
        this.sortedSlotIndexes.insert(index, slotIndex);
        return slotIndex;
    }
}

