/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors.nodes;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.algorithms.BinarySearchAlgorithm;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.collections.api.IValueReferenceVector;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;

public class NodeTreePointable
extends AbstractPointable {
    public static final int HEADER_NODEID_EXISTS_MASK = 1;
    public static final int HEADER_DICTIONARY_EXISTS_MASK = 2;
    public static final int HEADER_TYPE_EXISTS_MASK = 4;
    private static final int HEADER_OFFSET = 0;
    private static final int HEADER_SIZE = 1;
    private static final int NODE_ID_SIZE = 4;
    private static final int DICTIONARY_SIZE_SIZE = 4;
    private static final int DICTIONARY_NENTRIES_SIZE = 4;
    private static final int IDX_PTR_SLOT_SIZE = 4;
    private static final int SORTED_PTR_SLOT_SIZE = 4;
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public ITypeTraits getTypeTraits() {
            return VoidPointable.TYPE_TRAITS;
        }

        public IPointable createPointable() {
            return new NodeTreePointable();
        }
    };
    private final IValueReferenceVector sortedStringVector = new IValueReferenceVector(){

        public int getSize() {
            return NodeTreePointable.this.getDictionaryEntryCount();
        }

        public byte[] getBytes(int index) {
            return NodeTreePointable.this.bytes;
        }

        public int getStart(int index) {
            int dataAreaStart = NodeTreePointable.this.getDictionaryDataAreaStartOffset();
            int sortedPtrArrayStart = NodeTreePointable.this.getDictionarySortedPointerArrayOffset();
            int sortedSlotValue = IntegerPointable.getInteger((byte[])NodeTreePointable.this.bytes, (int)(sortedPtrArrayStart + index * 4));
            return dataAreaStart + sortedSlotValue;
        }

        public int getLength(int index) {
            return UTF8StringPointable.getUTFLength((byte[])NodeTreePointable.this.bytes, (int)this.getStart(index)) + 2;
        }
    };
    private final BinarySearchAlgorithm binSearch = new BinarySearchAlgorithm();

    public boolean nodeIdExists() {
        return (this.getHeader() & 1) != 0;
    }

    public boolean dictionaryExists() {
        return (this.getHeader() & 2) != 0;
    }

    public boolean typeExists() {
        return (this.getHeader() & 4) != 0;
    }

    public int getRootNodeId() {
        return this.nodeIdExists() ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getNodeIdOffset()) : -1;
    }

    public int getDictionaryEntryCount() {
        return this.dictionaryExists() ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getDictionaryEntryCountOffset()) : 0;
    }

    public void getString(int idx, IPointable string) {
        int nEntries = this.getDictionaryEntryCount();
        if (idx < 0 || idx >= nEntries) {
            throw new IllegalArgumentException(idx + " not within [0, " + nEntries + ")");
        }
        int dataAreaStart = this.getDictionaryDataAreaStartOffset();
        int idxSlotValue = idx == 0 ? 0 : IntegerPointable.getInteger((byte[])this.bytes, (int)(this.getDictionaryIndexPointerArrayOffset() + (idx - 1) * 4));
        int strLen = UTF8StringPointable.getUTFLength((byte[])this.bytes, (int)(dataAreaStart + idxSlotValue));
        string.set(this.bytes, dataAreaStart + idxSlotValue, strLen + 2);
    }

    public int lookupString(UTF8StringPointable key) {
        boolean found = this.binSearch.find(this.sortedStringVector, (IComparable)key);
        if (!found) {
            return -1;
        }
        int index = this.binSearch.getIndex();
        return IntegerPointable.getInteger((byte[])this.bytes, (int)(this.sortedStringVector.getStart(index) + this.sortedStringVector.getLength(index)));
    }

    public void getRootNode(TaggedValuePointable node) {
        node.set(this.bytes, this.getRootNodeOffset(), this.length - this.getRootNodeOffset() + this.start);
    }

    private byte getHeader() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.getHeaderOffset());
    }

    private int getHeaderOffset() {
        return this.start + 0;
    }

    private int getHeaderSize() {
        return 1;
    }

    private int getNodeIdOffset() {
        return this.getHeaderOffset() + this.getHeaderSize();
    }

    private int getNodeIdSize() {
        return this.nodeIdExists() ? 4 : 0;
    }

    public int getDictionaryOffset() {
        return this.getNodeIdOffset() + this.getNodeIdSize();
    }

    public int getDictionarySize() {
        return this.dictionaryExists() ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getDictionaryOffset()) : 0;
    }

    private int getDictionaryEntryCountOffset() {
        return this.getDictionaryOffset() + 4;
    }

    private int getDictionaryIndexPointerArrayOffset() {
        return this.getDictionaryEntryCountOffset() + 4;
    }

    private int getDictionarySortedPointerArrayOffset() {
        return this.getDictionaryIndexPointerArrayOffset() + this.getDictionaryEntryCount() * 4;
    }

    private int getDictionaryDataAreaStartOffset() {
        return this.getDictionaryIndexPointerArrayOffset() + this.getDictionaryEntryCount() * 8;
    }

    private int getRootNodeOffset() {
        return this.getDictionaryOffset() + this.getDictionarySize();
    }
}

