/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors.nodes;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.atomic.CodedQNamePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;

public class ElementNodePointable
extends AbstractPointable {
    public static final byte NS_CHUNK_EXISTS_MASK = 1;
    public static final byte ATTRIBUTES_CHUNK_EXISTS_MASK = 2;
    public static final byte CHILDREN_CHUNK_EXISTS_MASK = 4;
    private static final int HEADER_SIZE = 1;
    private static final int LOCAL_NODE_ID_SIZE = 4;
    private static final int NS_ENTRY_SIZE = 8;
    private static final int NS_CHUNK_SIZE_SIZE = 4;
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public ITypeTraits getTypeTraits() {
            return VoidPointable.TYPE_TRAITS;
        }

        public IPointable createPointable() {
            return new ElementNodePointable();
        }
    };

    public boolean nsChunkExists() {
        return (this.getHeader() & 1) != 0;
    }

    public boolean attributesChunkExists() {
        return (this.getHeader() & 2) != 0;
    }

    public boolean childrenChunkExists() {
        return (this.getHeader() & 4) != 0;
    }

    public void getName(CodedQNamePointable name) {
        name.set(this.bytes, this.getNameOffset(), this.getNameSize());
    }

    public void getTypeName(NodeTreePointable nodeTree, CodedQNamePointable typeName) {
        if (nodeTree.typeExists()) {
            typeName.set(this.bytes, this.getTypeOffset(), this.getTypeSize(nodeTree));
        } else {
            typeName.set(null, -1, -1);
        }
    }

    public int getLocalNodeId(NodeTreePointable nodeTree) {
        return nodeTree.nodeIdExists() ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getLocalNodeIdOffset(nodeTree)) : -1;
    }

    public int getNamespaceEntryCount(NodeTreePointable nodeTree) {
        return this.nsChunkExists() ? IntegerPointable.getInteger((byte[])this.bytes, (int)this.getNamespaceChunkOffset(nodeTree)) : 0;
    }

    public int getNamespacePrefixCode(NodeTreePointable nodeTree, int nsEntryIdx) {
        if (!this.nsChunkExists()) {
            return -1;
        }
        if (this.getNamespaceEntryCount(nodeTree) <= nsEntryIdx) {
            throw new IndexOutOfBoundsException(nsEntryIdx + " >= " + this.getNamespaceEntryCount(nodeTree));
        }
        return IntegerPointable.getInteger((byte[])this.bytes, (int)(this.getNamespaceChunkOffset(nodeTree) + 4 + 8 * nsEntryIdx));
    }

    public int getNamespaceURICode(NodeTreePointable nodeTree, int nsEntryIdx) {
        if (!this.nsChunkExists()) {
            return -1;
        }
        if (this.getNamespaceEntryCount(nodeTree) <= nsEntryIdx) {
            throw new IndexOutOfBoundsException(nsEntryIdx + " >= " + this.getNamespaceEntryCount(nodeTree));
        }
        return IntegerPointable.getInteger((byte[])this.bytes, (int)(this.getNamespaceChunkOffset(nodeTree) + 4 + 8 * nsEntryIdx + 1));
    }

    public void getAttributeSequence(NodeTreePointable nodeTree, SequencePointable attributes) {
        if (this.attributesChunkExists()) {
            attributes.set(this.bytes, this.getAttributeChunkOffset(nodeTree), this.getAttributeChunkSize(nodeTree));
        } else {
            attributes.set(null, -1, -1);
        }
    }

    public void getChildrenSequence(NodeTreePointable nodeTree, SequencePointable children) {
        if (this.childrenChunkExists()) {
            children.set(this.bytes, this.getChildrenChunkOffset(nodeTree), this.getChildrenChunkSize(nodeTree));
        } else {
            children.set(null, -1, -1);
        }
    }

    private byte getHeader() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.start);
    }

    private int getNameOffset() {
        return this.start + 1;
    }

    private int getNameSize() {
        return 12;
    }

    private int getTypeOffset() {
        return this.getNameOffset() + this.getNameSize();
    }

    private int getTypeSize(NodeTreePointable nodeTree) {
        return nodeTree.typeExists() ? 12 : 0;
    }

    private int getLocalNodeIdOffset(NodeTreePointable nodeTree) {
        return this.getTypeOffset() + this.getTypeSize(nodeTree);
    }

    private int getLocalNodeIdSize(NodeTreePointable nodeTree) {
        return nodeTree.nodeIdExists() ? 4 : 0;
    }

    private int getNamespaceChunkOffset(NodeTreePointable nodeTree) {
        return this.getLocalNodeIdOffset(nodeTree) + this.getLocalNodeIdSize(nodeTree);
    }

    private int getNamespaceChunkSize(NodeTreePointable nodeTree) {
        return this.nsChunkExists() ? this.getNamespaceEntryCount(nodeTree) * 8 + 4 : 0;
    }

    private int getAttributeChunkOffset(NodeTreePointable nodeTree) {
        return this.getNamespaceChunkOffset(nodeTree) + this.getNamespaceChunkSize(nodeTree);
    }

    private int getAttributeChunkSize(NodeTreePointable nodeTree) {
        return this.attributesChunkExists() ? SequencePointable.getSequenceLength(this.bytes, this.getAttributeChunkOffset(nodeTree)) : 0;
    }

    private int getChildrenChunkOffset(NodeTreePointable nodeTree) {
        return this.getAttributeChunkOffset(nodeTree) + this.getAttributeChunkSize(nodeTree);
    }

    private int getChildrenChunkSize(NodeTreePointable nodeTree) {
        return this.childrenChunkExists() ? SequencePointable.getSequenceLength(this.bytes, this.getChildrenChunkOffset(nodeTree)) : 0;
    }
}

