/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors.atomic;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import org.apache.vxquery.datamodel.api.ITime;
import org.apache.vxquery.datamodel.api.ITimezone;

public class XSTimePointable
extends AbstractPointable
implements ITime,
ITimezone {
    public static final int HOUR_OFFSET = 0;
    public static final int MINUTE_OFFSET = 1;
    public static final int MILLISECOND_OFFSET = 2;
    public static final int TIMEZONE_HOUR_OFFSET = 6;
    public static final int TIMEZONE_MINUTE_OFFSET = 7;
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 8;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public IPointable createPointable() {
            return new XSTimePointable();
        }

        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public void setTime(long hour, long minute, long second, long timezoneHour, long timezoneMinute) {
        XSTimePointable.setTime(this.bytes, this.start, hour, minute, second, timezoneHour, timezoneMinute);
    }

    public static void setTime(byte[] bytes, int start, long hour, long minute, long second, long timezoneHour, long timezoneMinute) {
        BytePointable.setByte((byte[])bytes, (int)(start + 0), (byte)((byte)hour));
        BytePointable.setByte((byte[])bytes, (int)(start + 1), (byte)((byte)minute));
        IntegerPointable.setInteger((byte[])bytes, (int)(start + 2), (int)((byte)second));
        BytePointable.setByte((byte[])bytes, (int)(start + 6), (byte)((byte)timezoneHour));
        BytePointable.setByte((byte[])bytes, (int)(start + 7), (byte)((byte)timezoneMinute));
    }

    @Override
    public long getHour() {
        return XSTimePointable.getHour(this.bytes, this.start);
    }

    public static long getHour(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 0));
    }

    @Override
    public long getMinute() {
        return XSTimePointable.getMinute(this.bytes, this.start);
    }

    public static long getMinute(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 1));
    }

    @Override
    public long getMilliSecond() {
        return XSTimePointable.getMilliSecond(this.bytes, this.start);
    }

    public static long getMilliSecond(byte[] bytes, int start) {
        return IntegerPointable.getInteger((byte[])bytes, (int)(start + 2));
    }

    @Override
    public long getTimezoneHour() {
        return XSTimePointable.getTimezoneHour(this.bytes, this.start);
    }

    public static long getTimezoneHour(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 6));
    }

    @Override
    public long getTimezoneMinute() {
        return XSTimePointable.getTimezoneMinute(this.bytes, this.start);
    }

    public static long getTimezoneMinute(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 7));
    }

    @Override
    public long getTimezone() {
        return XSTimePointable.getTimezone(this.bytes, this.start);
    }

    public static long getTimezone(byte[] bytes, int start) {
        return XSTimePointable.getTimezoneHour(bytes, start) * 60L + XSTimePointable.getTimezoneMinute(bytes, start);
    }

    @Override
    public long getDayTime() {
        return XSTimePointable.getDayTime(this.bytes, this.start);
    }

    public static long getDayTime(byte[] bytes, int start) {
        return (XSTimePointable.getHour(bytes, start) * 60L + XSTimePointable.getMinute(bytes, start)) * 60L * 1000L + XSTimePointable.getMilliSecond(bytes, start);
    }

    @Override
    public long getYearMonth() {
        return XSTimePointable.getYearMonth(this.bytes, this.start);
    }

    public static long getYearMonth(byte[] bytes, int start) {
        return 0L;
    }
}

