/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors.atomic;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IComparable;
import edu.uci.ics.hyracks.data.std.api.IHashable;
import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;

public class XSDecimalPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    private static final int DECIMAL_PLACE_OFFSET = 0;
    private static final int VALUE_OFFSET = 1;
    public static final int PRECISION = 18;
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 9;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public IPointable createPointable() {
            return new XSDecimalPointable();
        }

        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public int compareTo(byte[] bytes, int start, int length) {
        long v = this.getDecimalValue();
        byte p = this.getDecimalPlace();
        long ov = XSDecimalPointable.getDecimalValue(bytes, start);
        byte op = XSDecimalPointable.getDecimalPlace(bytes, start);
        int diff = p - op;
        if (diff > 0) {
            ov = Math.round((double)ov / Math.pow(10.0, diff));
        } else if (diff < 0) {
            v = Math.round((double)v / Math.pow(10.0, diff));
        }
        return v < ov ? -1 : (v > ov ? 1 : 0);
    }

    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    public void setDecimal(long value, byte decimalPlace) {
        BytePointable.setByte((byte[])this.bytes, (int)(this.start + 0), (byte)decimalPlace);
        LongPointable.setLong((byte[])this.bytes, (int)(this.start + 1), (long)value);
        this.normalize();
    }

    public void normalize() {
        XSDecimalPointable.normalize(this.bytes, this.start);
    }

    public static void normalize(byte[] bytes, int start) {
        byte decimalPlace = XSDecimalPointable.getDecimalPlace(bytes, start);
        long value = XSDecimalPointable.getDecimalValue(bytes, start);
        while (value != 0L && value % 10L == 0L) {
            value /= 10L;
            decimalPlace = (byte)(decimalPlace - 1);
        }
        BytePointable.setByte((byte[])bytes, (int)(start + 0), (byte)decimalPlace);
        LongPointable.setLong((byte[])bytes, (int)(start + 1), (long)value);
    }

    public byte getDecimalPlace() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.start);
    }

    public static byte getDecimalPlace(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 0));
    }

    public long getDecimalValue() {
        return XSDecimalPointable.getDecimalValue(this.bytes, this.start);
    }

    public static long getDecimalValue(byte[] bytes, int start) {
        return LongPointable.getLong((byte[])bytes, (int)(start + 1));
    }

    public int hash() {
        long v = this.getDecimalValue();
        return (int)(v ^ v >>> 32);
    }

    public long getBeforeDecimalPlaceRounded() {
        return XSDecimalPointable.getBeforeDecimalPlaceRounded(this.bytes, this.start);
    }

    public static long getBeforeDecimalPlaceRounded(byte[] bytes, int start) {
        if (XSDecimalPointable.getDecimalPlace(bytes, start) != 0) {
            return Math.round((double)XSDecimalPointable.getDecimalValue(bytes, start) / Math.pow(10.0, XSDecimalPointable.getDecimalPlace(bytes, start)));
        }
        return XSDecimalPointable.getDecimalValue(bytes, start);
    }

    public long getBeforeDecimalPlace() {
        return XSDecimalPointable.getBeforeDecimalPlace(this.bytes, this.start);
    }

    public static long getBeforeDecimalPlace(byte[] bytes, int start) {
        if (XSDecimalPointable.getDecimalPlace(bytes, start) != 0) {
            return (long)((double)XSDecimalPointable.getDecimalValue(bytes, start) / Math.pow(10.0, XSDecimalPointable.getDecimalPlace(bytes, start)));
        }
        return XSDecimalPointable.getDecimalValue(bytes, start);
    }

    public byte getDigitCount() {
        return XSDecimalPointable.getDigitCount(this.bytes, this.start);
    }

    public static byte getDigitCount(byte[] bytes, int start) {
        long value = XSDecimalPointable.getDecimalValue(bytes, start);
        if (value < 0L) {
            value *= -1L;
        }
        long check = 10L;
        for (byte i = 1; i < 18; i = (byte)(i + 1)) {
            if (value < check) {
                return i;
            }
            check *= 10L;
        }
        return 18;
    }

    public byte byteValue() {
        return (byte)this.getBeforeDecimalPlace();
    }

    public short shortValue() {
        return (short)this.getBeforeDecimalPlace();
    }

    public int intValue() {
        return (int)this.getBeforeDecimalPlace();
    }

    public long longValue() {
        return this.getBeforeDecimalPlace();
    }

    public float floatValue() {
        return (float)((double)this.getDecimalValue() / Math.pow(10.0, this.getDecimalPlace()));
    }

    public double doubleValue() {
        return (double)this.getDecimalValue() / Math.pow(10.0, this.getDecimalPlace());
    }
}

