/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors.atomic;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.vxquery.datamodel.api.IDate;
import org.apache.vxquery.datamodel.api.ITime;
import org.apache.vxquery.datamodel.api.ITimezone;

public class XSDateTimePointable
extends AbstractPointable
implements IDate,
ITime,
ITimezone {
    public static final int YEAR_OFFSET = 0;
    public static final int MONTH_OFFSET = 2;
    public static final int DAY_OFFSET = 3;
    public static final int HOUR_OFFSET = 4;
    public static final int MINUTE_OFFSET = 5;
    public static final int MILLISECOND_OFFSET = 6;
    public static final int TIMEZONE_HOUR_OFFSET = 10;
    public static final int TIMEZONE_MINUTE_OFFSET = 11;
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 12;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public IPointable createPointable() {
            return new XSDateTimePointable();
        }

        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public void setCurrentDateTime() {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int ms = cal.get(14);
        int tzOffsetInMs = tz.getOffset(cal.get(0), year, month, day, cal.get(7), ms);
        int tzOffsetInMin = tzOffsetInMs / 1000 / 60;
        this.setDateTime(year, month + 1, day, cal.get(11), cal.get(12), cal.get(13) * 1000 + ms, tzOffsetInMin / 60, tzOffsetInMin % 60);
    }

    public void setDateTime(long year, long month, long day, long hour, long minute, long milliSecond, long timezoneHour, long timezoneMinute) {
        XSDateTimePointable.setDateTime(this.bytes, this.start, year, month, day, hour, minute, milliSecond, timezoneHour, timezoneMinute);
    }

    public static void setDateTime(byte[] bytes, int start, long year, long month, long day, long hour, long minute, long milliSecond, long timezoneHour, long timezoneMinute) {
        ShortPointable.setShort((byte[])bytes, (int)(start + 0), (short)((short)year));
        BytePointable.setByte((byte[])bytes, (int)(start + 2), (byte)((byte)month));
        BytePointable.setByte((byte[])bytes, (int)(start + 3), (byte)((byte)day));
        BytePointable.setByte((byte[])bytes, (int)(start + 4), (byte)((byte)hour));
        BytePointable.setByte((byte[])bytes, (int)(start + 5), (byte)((byte)minute));
        IntegerPointable.setInteger((byte[])bytes, (int)(start + 6), (int)((int)milliSecond));
        BytePointable.setByte((byte[])bytes, (int)(start + 10), (byte)((byte)timezoneHour));
        BytePointable.setByte((byte[])bytes, (int)(start + 11), (byte)((byte)timezoneMinute));
    }

    @Override
    public long getYear() {
        return XSDateTimePointable.getYear(this.bytes, this.start);
    }

    public static long getYear(byte[] bytes, int start) {
        return ShortPointable.getShort((byte[])bytes, (int)(start + 0));
    }

    @Override
    public long getMonth() {
        return XSDateTimePointable.getMonth(this.bytes, this.start);
    }

    public static long getMonth(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 2));
    }

    @Override
    public long getDay() {
        return XSDateTimePointable.getDay(this.bytes, this.start);
    }

    public static long getDay(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 3));
    }

    @Override
    public long getHour() {
        return XSDateTimePointable.getHour(this.bytes, this.start);
    }

    public static long getHour(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 4));
    }

    @Override
    public long getMinute() {
        return XSDateTimePointable.getMinute(this.bytes, this.start);
    }

    public static long getMinute(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 5));
    }

    @Override
    public long getMilliSecond() {
        return XSDateTimePointable.getMilliSecond(this.bytes, this.start);
    }

    public static long getMilliSecond(byte[] bytes, int start) {
        return IntegerPointable.getInteger((byte[])bytes, (int)(start + 6));
    }

    @Override
    public long getTimezoneHour() {
        return XSDateTimePointable.getTimezoneHour(this.bytes, this.start);
    }

    public static long getTimezoneHour(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 10));
    }

    @Override
    public long getTimezoneMinute() {
        return XSDateTimePointable.getTimezoneMinute(this.bytes, this.start);
    }

    public static long getTimezoneMinute(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 11));
    }

    @Override
    public long getTimezone() {
        return XSDateTimePointable.getTimezone(this.bytes, this.start);
    }

    public static long getTimezone(byte[] bytes, int start) {
        return XSDateTimePointable.getTimezoneHour(bytes, start) * 60L + XSDateTimePointable.getTimezoneMinute(bytes, start);
    }

    @Override
    public long getYearMonth() {
        return XSDateTimePointable.getYearMonth(this.bytes, this.start);
    }

    public static long getYearMonth(byte[] bytes, int start) {
        return XSDateTimePointable.getYear(bytes, start) * 12L + XSDateTimePointable.getMonth(bytes, start);
    }

    @Override
    public long getDayTime() {
        return XSDateTimePointable.getDayTime(this.bytes, this.start);
    }

    public static long getDayTime(byte[] bytes, int start) {
        return XSDateTimePointable.getDay(bytes, start) * 86400000L + XSDateTimePointable.getHour(bytes, start) * 3600000L + XSDateTimePointable.getMinute(bytes, start) * 60000L + XSDateTimePointable.getMilliSecond(bytes, start);
    }

    public String toString() {
        return XSDateTimePointable.toString(this.bytes, this.start);
    }

    public static String toString(byte[] bytes, int start) {
        long millis = XSDateTimePointable.getMilliSecond(bytes, start);
        return XSDateTimePointable.getYear(bytes, start) + "-" + XSDateTimePointable.getMonth(bytes, start) + "-" + XSDateTimePointable.getDay(bytes, start) + "T" + XSDateTimePointable.getHour(bytes, start) + ":" + XSDateTimePointable.getMinute(bytes, start) + ":" + millis / 1000L + "." + millis % 1000L + (XSDateTimePointable.getTimezoneHour(bytes, start) != 127L && XSDateTimePointable.getTimezoneMinute(bytes, start) != 127L ? (XSDateTimePointable.getTimezoneHour(bytes, start) < 0L || XSDateTimePointable.getTimezoneMinute(bytes, start) < 0L ? "" : "+") + XSDateTimePointable.getTimezoneHour(bytes, start) + ":" + XSDateTimePointable.getTimezoneMinute(bytes, start) : "");
    }
}

