/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors.atomic;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import org.apache.vxquery.datamodel.api.IDate;
import org.apache.vxquery.datamodel.api.ITimezone;

public class XSDatePointable
extends AbstractPointable
implements IDate,
ITimezone {
    public static final int YEAR_OFFSET = 0;
    public static final int MONTH_OFFSET = 2;
    public static final int DAY_OFFSET = 3;
    public static final int TIMEZONE_HOUR_OFFSET = 4;
    public static final int TIMEZONE_MINUTE_OFFSET = 5;
    private static final long CHRONON_OF_DAY = 86400000L;
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 6;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public IPointable createPointable() {
            return new XSDatePointable();
        }

        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public void setDate(long year, long month, long day, long timezoneHour, long timezoneMinute) {
        XSDatePointable.setDate(this.bytes, this.start, year, month, day, timezoneHour, timezoneMinute);
    }

    public static void setDate(byte[] bytes, int start, long year, long month, long day, long timezoneHour, long timezoneMinute) {
        ShortPointable.setShort((byte[])bytes, (int)(start + 0), (short)((short)year));
        BytePointable.setByte((byte[])bytes, (int)(start + 2), (byte)((byte)month));
        BytePointable.setByte((byte[])bytes, (int)(start + 3), (byte)((byte)day));
        BytePointable.setByte((byte[])bytes, (int)(start + 4), (byte)((byte)timezoneHour));
        BytePointable.setByte((byte[])bytes, (int)(start + 5), (byte)((byte)timezoneMinute));
    }

    @Override
    public long getYear() {
        return XSDatePointable.getYear(this.bytes, this.start);
    }

    public static long getYear(byte[] bytes, int start) {
        return ShortPointable.getShort((byte[])bytes, (int)(start + 0));
    }

    @Override
    public long getMonth() {
        return XSDatePointable.getMonth(this.bytes, this.start);
    }

    public static long getMonth(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 2));
    }

    @Override
    public long getDay() {
        return XSDatePointable.getDay(this.bytes, this.start);
    }

    public static long getDay(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 3));
    }

    @Override
    public long getTimezoneHour() {
        return XSDatePointable.getTimezoneHour(this.bytes, this.start);
    }

    public static long getTimezoneHour(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 4));
    }

    @Override
    public long getTimezoneMinute() {
        return XSDatePointable.getTimezoneMinute(this.bytes, this.start);
    }

    public static long getTimezoneMinute(byte[] bytes, int start) {
        return BytePointable.getByte((byte[])bytes, (int)(start + 5));
    }

    @Override
    public long getTimezone() {
        return XSDatePointable.getTimezone(this.bytes, this.start);
    }

    public static long getTimezone(byte[] bytes, int start) {
        return XSDatePointable.getTimezoneHour(bytes, start) * 60L + XSDatePointable.getTimezoneMinute(bytes, start);
    }

    @Override
    public long getYearMonth() {
        return XSDatePointable.getYearMonth(this.bytes, this.start);
    }

    public static long getYearMonth(byte[] bytes, int start) {
        return XSDatePointable.getYear(bytes, start) * 12L + XSDatePointable.getMonth(bytes, start);
    }

    @Override
    public long getDayTime() {
        return XSDatePointable.getDayTime(this.bytes, this.start);
    }

    public static long getDayTime(byte[] bytes, int start) {
        return XSDatePointable.getDay(bytes, start) * 86400000L;
    }
}

