/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.data.std.api.AbstractPointable;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;

public class SequencePointable
extends AbstractPointable {
    private static final int ENTRY_COUNT_SIZE = 4;
    private static final int SLOT_SIZE = 4;
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        public ITypeTraits getTypeTraits() {
            return VoidPointable.TYPE_TRAITS;
        }

        public IPointable createPointable() {
            return new SequencePointable();
        }
    };

    public static int getSequenceLength(byte[] bytes, int start) {
        int entryCount = SequencePointable.getEntryCount(bytes, start);
        return SequencePointable.getSlotValue(bytes, start, entryCount - 1) + (SequencePointable.getDataAreaOffset(bytes, start) - start);
    }

    public int getEntryCount() {
        return SequencePointable.getEntryCount(this.bytes, this.start);
    }

    private static int getEntryCount(byte[] bytes, int start) {
        return IntegerPointable.getInteger((byte[])bytes, (int)start);
    }

    public void getEntry(int idx, IPointable pointer) {
        int dataAreaOffset = SequencePointable.getDataAreaOffset(this.bytes, this.start);
        pointer.set(this.bytes, dataAreaOffset + this.getRelativeEntryStartOffset(idx), this.getEntryLength(idx));
    }

    private static int getSlotValue(byte[] bytes, int start, int idx) {
        return IntegerPointable.getInteger((byte[])bytes, (int)(SequencePointable.getSlotArrayOffset(start) + idx * 4));
    }

    private int getRelativeEntryStartOffset(int idx) {
        return idx == 0 ? 0 : SequencePointable.getSlotValue(this.bytes, this.start, idx - 1);
    }

    private int getEntryLength(int idx) {
        return SequencePointable.getSlotValue(this.bytes, this.start, idx) - this.getRelativeEntryStartOffset(idx);
    }

    private static int getSlotArrayOffset(int start) {
        return start + 4;
    }

    private static int getDataAreaOffset(byte[] bytes, int start) {
        return SequencePointable.getSlotArrayOffset(start) + SequencePointable.getEntryCount(bytes, start) * 4;
    }
}

