/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.datamodel.accessors;

import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.vxquery.datamodel.accessors.PointableCache;

public class PointablePool {
    private final Map<Class<? extends IPointable>, IPointableFactory> pfMap = new HashMap<Class<? extends IPointable>, IPointableFactory>();
    private final Map<Class<? extends IPointable>, PointableCache<? extends IPointable>> pcMap = new HashMap<Class<? extends IPointable>, PointableCache<? extends IPointable>>();

    PointablePool() {
    }

    <T extends IPointable> void register(Class<T> klass, IPointableFactory factory) {
        this.pfMap.put(klass, factory);
        this.pcMap.put(klass, new PointableCache());
    }

    public <T extends IPointable> T takeOne(Class<T> klass) {
        PointableCache<? extends IPointable> pc = this.pcMap.get(klass);
        IPointable p = pc.takeOne();
        if (p != null) {
            return (T)p;
        }
        IPointableFactory pf = this.pfMap.get(klass);
        return (T)pf.createPointable();
    }

    public <T extends IPointable> void giveBack(T pointable) {
        PointableCache<? extends IPointable> pc = this.pcMap.get(pointable.getClass());
        pc.giveBack(pointable);
    }
}

