/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.vxquery.collations.Collation;
import org.apache.vxquery.context.IStaticContextFactory;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.context.StaticContextImplFactory;
import org.apache.vxquery.context.XQueryVariable;
import org.apache.vxquery.functions.Function;
import org.apache.vxquery.types.AttributeType;
import org.apache.vxquery.types.ElementType;
import org.apache.vxquery.types.SchemaType;
import org.apache.vxquery.types.SequenceType;

public class StaticContextImpl
implements StaticContext {
    private final StaticContext parent;
    private final Map<String, String> namespaceMap;
    private final Map<QName, XQueryVariable> variableMap;
    protected final Map<String, Collation> collationMap;
    protected final Map<QName, Function[]> functionMap;
    protected final Map<String, SequenceType> documentTypeMap;
    protected final Map<String, SequenceType> collectionTypeMap;
    protected final List<Pair<String, List<String>>> moduleImports;
    protected final List<Pair<String, List<String>>> schemaImports;
    protected final Map<QName, SchemaType> schemaTypeMap;
    protected final Map<SequenceType, Integer> sequenceTypeMap;
    protected final List<SequenceType> sequenceTypeList;
    protected final Map<QName, AttributeType> attributeDeclarationMap;
    protected final Map<QName, ElementType> elementDeclarationMap;
    protected final Map<QName, String> options;
    private StaticContext.BoundarySpaceProperty boundarySpaceProperty;
    private String defaultFunctionNamespaceUri;
    private String defaultElementNamespaceUri;
    private StaticContext.OrderingModeProperty orderingModeProperty;
    private StaticContext.EmptyOrderProperty emptyOrderProperty;
    private String defaultCollation;
    private String baseUri;
    private StaticContext.ConstructionModeProperty constructionModeProperty;
    private StaticContext.CopyNamespacesModeProperty copyNamespacesModeProperty;
    private SequenceType defaultCollectionType;
    private int typeCounter;

    public StaticContextImpl(StaticContext parent) {
        this.parent = parent;
        this.namespaceMap = new LinkedHashMap<String, String>();
        this.variableMap = new LinkedHashMap<QName, XQueryVariable>();
        this.collationMap = new LinkedHashMap<String, Collation>();
        this.functionMap = new LinkedHashMap<QName, Function[]>();
        this.documentTypeMap = new LinkedHashMap<String, SequenceType>();
        this.collectionTypeMap = new LinkedHashMap<String, SequenceType>();
        this.moduleImports = new ArrayList<Pair<String, List<String>>>();
        this.schemaImports = new ArrayList<Pair<String, List<String>>>();
        this.schemaTypeMap = new LinkedHashMap<QName, SchemaType>();
        this.sequenceTypeMap = new HashMap<SequenceType, Integer>();
        this.sequenceTypeList = new ArrayList<SequenceType>();
        this.attributeDeclarationMap = new LinkedHashMap<QName, AttributeType>();
        this.elementDeclarationMap = new LinkedHashMap<QName, ElementType>();
        this.options = new LinkedHashMap<QName, String>();
        this.typeCounter = parent == null ? 0 : parent.getMaxSequenceTypeCode();
    }

    @Override
    public StaticContext getParent() {
        return this.parent;
    }

    @Override
    public String lookupNamespaceUri(String prefix) {
        if (this.namespaceMap.containsKey(prefix)) {
            return this.namespaceMap.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.lookupNamespaceUri(prefix);
        }
        return null;
    }

    @Override
    public void registerNamespaceUri(String prefix, String uri) {
        this.namespaceMap.put(prefix, uri);
    }

    @Override
    public Collation lookupCollation(String collationName) {
        if (this.collationMap.containsKey(collationName)) {
            return this.collationMap.get(collationName);
        }
        if (this.parent != null) {
            return this.parent.lookupCollation(collationName);
        }
        return null;
    }

    @Override
    public void registerCollation(String collationName, Collation collation) {
        this.collationMap.put(collationName, collation);
    }

    @Override
    public Function lookupFunction(QName functionName, int arity) {
        Function[] fns;
        if (this.functionMap.containsKey(functionName) && (fns = this.functionMap.get(functionName)) != null && fns.length > arity && fns[arity] != null) {
            return fns[arity];
        }
        if (this.parent != null) {
            return this.parent.lookupFunction(functionName, arity);
        }
        return null;
    }

    @Override
    public Function[] lookupFunctions(QName functionName) {
        if (this.functionMap.containsKey(functionName)) {
            return this.functionMap.get(functionName);
        }
        if (this.parent != null) {
            return this.parent.lookupFunctions(functionName);
        }
        return null;
    }

    @Override
    public void registerFunction(Function function) {
        Function[] fns = this.functionMap.get(function.getName());
        int arity = function.getSignature().getArity();
        if (fns == null) {
            fns = new Function[arity + 1];
            fns[arity] = function;
            this.functionMap.put(function.getName(), fns);
        } else if (fns.length <= arity) {
            Function[] newFns = new Function[arity + 1];
            System.arraycopy(fns, 0, newFns, 0, fns.length);
            newFns[arity] = function;
            this.functionMap.put(function.getName(), newFns);
        } else {
            fns[arity] = function;
        }
    }

    @Override
    public Iterator<Function> listFunctions() {
        return new Iterator<Function>(){
            private Iterator<Function[]> faIter;
            private Function[] fa;
            private int faIdx;
            {
                this.faIter = StaticContextImpl.this.functionMap.values().iterator();
                this.fa = null;
                this.faIdx = 0;
            }

            @Override
            public boolean hasNext() {
                this.fetchNext();
                return this.fa != null;
            }

            @Override
            public Function next() {
                this.fetchNext();
                if (this.fa == null) {
                    throw new NoSuchElementException();
                }
                return this.fa[this.faIdx++];
            }

            private void fetchNext() {
                block3: {
                    while (true) {
                        if (this.fa != null && this.faIdx < this.fa.length) {
                            if (this.fa[this.faIdx] == null) {
                                ++this.faIdx;
                                continue;
                            }
                            break block3;
                        }
                        if (!this.faIter.hasNext()) break;
                        this.fa = this.faIter.next();
                        this.faIdx = 0;
                    }
                    this.fa = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public SequenceType lookupDocumentType(String docUri) {
        if (this.documentTypeMap.containsKey(docUri)) {
            return this.documentTypeMap.get(docUri);
        }
        if (this.parent != null) {
            return this.parent.lookupDocumentType(docUri);
        }
        return null;
    }

    @Override
    public void registerDocumentType(String docUri, SequenceType type) {
        this.documentTypeMap.put(docUri, type);
    }

    @Override
    public XQueryVariable lookupVariable(QName name) {
        if (this.variableMap.containsKey(name)) {
            return this.variableMap.get(name);
        }
        if (this.parent != null) {
            return this.parent.lookupVariable(name);
        }
        return null;
    }

    @Override
    public void registerVariable(XQueryVariable var) {
        this.variableMap.put(var.getName(), var);
    }

    @Override
    public Iterator<XQueryVariable> listVariables() {
        return Collections.unmodifiableCollection(this.variableMap.values()).iterator();
    }

    @Override
    public SequenceType lookupCollectionType(String collectionUri) {
        if (this.collectionTypeMap.containsKey(collectionUri)) {
            return this.collectionTypeMap.get(collectionUri);
        }
        if (this.parent != null) {
            return this.parent.lookupCollectionType(collectionUri);
        }
        return null;
    }

    @Override
    public void registerCollectionType(String collectionUri, SequenceType type) {
        this.collectionTypeMap.put(collectionUri, type);
    }

    @Override
    public Iterator<Pair<String, List<String>>> listModules() {
        return new ConcatenatingIterator<Pair<String, List<String>>>(){

            @Override
            protected Iterator<Pair<String, List<String>>> getCurrentIterator() {
                return StaticContextImpl.this.moduleImports.iterator();
            }

            @Override
            protected Iterator<Pair<String, List<String>>> getParentIterator() {
                if (StaticContextImpl.this.parent != null) {
                    return StaticContextImpl.this.parent.listModules();
                }
                return null;
            }
        };
    }

    @Override
    public void registerModuleImport(String uri, List<String> locations) {
        this.moduleImports.add((Pair<String, List<String>>)Pair.of((Object)uri, locations));
    }

    @Override
    public Iterator<Pair<String, List<String>>> listSchemas() {
        return new ConcatenatingIterator<Pair<String, List<String>>>(){

            @Override
            protected Iterator<Pair<String, List<String>>> getCurrentIterator() {
                return StaticContextImpl.this.schemaImports.iterator();
            }

            @Override
            protected Iterator<Pair<String, List<String>>> getParentIterator() {
                if (StaticContextImpl.this.parent != null) {
                    return StaticContextImpl.this.parent.listSchemas();
                }
                return null;
            }
        };
    }

    @Override
    public void registerSchemaImport(String uri, List<String> locations) {
        this.schemaImports.add((Pair<String, List<String>>)Pair.of((Object)uri, locations));
    }

    @Override
    public SchemaType lookupSchemaType(QName name) {
        if (this.schemaTypeMap.containsKey(name)) {
            return this.schemaTypeMap.get(name);
        }
        if (this.parent != null) {
            return this.parent.lookupSchemaType(name);
        }
        return null;
    }

    @Override
    public void registerSchemaType(QName name, SchemaType type) {
        this.schemaTypeMap.put(name, type);
    }

    @Override
    public int lookupSequenceType(SequenceType type) {
        if (this.sequenceTypeMap.containsKey(type)) {
            return this.sequenceTypeMap.get(type);
        }
        if (this.parent != null) {
            return this.parent.lookupSequenceType(type);
        }
        return -1;
    }

    @Override
    public SequenceType lookupSequenceType(int code) {
        int maxParentTypeCode;
        int n = maxParentTypeCode = this.parent == null ? 0 : this.parent.getMaxSequenceTypeCode();
        if (code >= maxParentTypeCode) {
            return this.sequenceTypeList.get(code - maxParentTypeCode);
        }
        return this.parent.lookupSequenceType(code);
    }

    @Override
    public int encodeSequenceType(SequenceType type) {
        int code = this.lookupSequenceType(type);
        if (code == -1) {
            code = this.typeCounter++;
            this.sequenceTypeMap.put(type, code);
            this.sequenceTypeList.add(type);
            return code;
        }
        if (this.sequenceTypeMap.containsKey(type)) {
            return this.sequenceTypeMap.get(type);
        }
        return -1;
    }

    List<SequenceType> getSequenceTypeList() {
        return this.sequenceTypeList;
    }

    @Override
    public int getMaxSequenceTypeCode() {
        return this.typeCounter;
    }

    @Override
    public AttributeType lookupAttributeDeclaration(QName name) {
        if (this.attributeDeclarationMap.containsKey(name)) {
            return this.attributeDeclarationMap.get(name);
        }
        if (this.parent != null) {
            return this.parent.lookupAttributeDeclaration(name);
        }
        return null;
    }

    @Override
    public void registerAttributeDeclaration(QName name, AttributeType attrDecl) {
        this.attributeDeclarationMap.put(name, attrDecl);
    }

    @Override
    public ElementType lookupElementDeclaration(QName name) {
        if (this.elementDeclarationMap.containsKey(name)) {
            return this.elementDeclarationMap.get(name);
        }
        if (this.parent != null) {
            return this.parent.lookupElementDeclaration(name);
        }
        return null;
    }

    @Override
    public void registerElementDeclaration(QName name, ElementType elemDecl) {
        this.elementDeclarationMap.put(name, elemDecl);
    }

    @Override
    public StaticContext.BoundarySpaceProperty getBoundarySpaceProperty() {
        if (this.boundarySpaceProperty != null) {
            return this.boundarySpaceProperty;
        }
        if (this.parent != null) {
            return this.parent.getBoundarySpaceProperty();
        }
        return null;
    }

    @Override
    public void setBoundarySpaceProperty(StaticContext.BoundarySpaceProperty boundarySpaceProperty) {
        this.boundarySpaceProperty = boundarySpaceProperty;
    }

    @Override
    public String getDefaultFunctionNamespaceUri() {
        if (this.defaultFunctionNamespaceUri != null) {
            return this.defaultFunctionNamespaceUri;
        }
        if (this.parent != null) {
            return this.parent.getDefaultFunctionNamespaceUri();
        }
        return null;
    }

    @Override
    public void setDefaultFunctionNamespaceUri(String uri) {
        this.defaultFunctionNamespaceUri = uri;
    }

    @Override
    public String getDefaultElementNamespaceUri() {
        if (this.defaultElementNamespaceUri != null) {
            return this.defaultElementNamespaceUri;
        }
        if (this.parent != null) {
            return this.parent.getDefaultElementNamespaceUri();
        }
        return null;
    }

    @Override
    public void setDefaultElementNamespaceUri(String uri) {
        this.defaultElementNamespaceUri = uri;
    }

    @Override
    public StaticContext.OrderingModeProperty getOrderingModeProperty() {
        if (this.orderingModeProperty != null) {
            return this.orderingModeProperty;
        }
        if (this.parent != null) {
            return this.parent.getOrderingModeProperty();
        }
        return null;
    }

    @Override
    public void setOrderingModeProperty(StaticContext.OrderingModeProperty orderingMode) {
        this.orderingModeProperty = orderingMode;
    }

    @Override
    public StaticContext.EmptyOrderProperty getEmptyOrderProperty() {
        if (this.emptyOrderProperty != null) {
            return this.emptyOrderProperty;
        }
        if (this.parent != null) {
            return this.parent.getEmptyOrderProperty();
        }
        return null;
    }

    @Override
    public void setEmptyOrderProperty(StaticContext.EmptyOrderProperty emptyOrder) {
        this.emptyOrderProperty = emptyOrder;
    }

    @Override
    public String getDefaultCollation() {
        if (this.defaultCollation != null) {
            return this.defaultCollation;
        }
        if (this.parent != null) {
            return this.parent.getDefaultCollation();
        }
        return null;
    }

    @Override
    public void setDefaultCollation(String defaultCollation) {
        this.defaultCollation = defaultCollation;
    }

    @Override
    public String getBaseUri() {
        if (this.baseUri != null) {
            return this.baseUri;
        }
        if (this.parent != null) {
            return this.parent.getBaseUri();
        }
        return null;
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    @Override
    public StaticContext.ConstructionModeProperty getConstructionModeProperty() {
        if (this.constructionModeProperty != null) {
            return this.constructionModeProperty;
        }
        if (this.parent != null) {
            return this.parent.getConstructionModeProperty();
        }
        return null;
    }

    @Override
    public void setConstructionModeProperty(StaticContext.ConstructionModeProperty constructionMode) {
        this.constructionModeProperty = constructionMode;
    }

    @Override
    public StaticContext.CopyNamespacesModeProperty getCopyNamespacesModeProperty() {
        if (this.copyNamespacesModeProperty != null) {
            return this.copyNamespacesModeProperty;
        }
        if (this.parent != null) {
            return this.parent.getCopyNamespacesModeProperty();
        }
        return null;
    }

    @Override
    public void setCopyNamespacesModeProperty(StaticContext.CopyNamespacesModeProperty copyNamespacesMode) {
        this.copyNamespacesModeProperty = copyNamespacesMode;
    }

    @Override
    public SequenceType getDefaultCollectionType() {
        if (this.defaultCollectionType != null) {
            return this.defaultCollectionType;
        }
        if (this.parent != null) {
            return this.parent.getDefaultCollectionType();
        }
        return null;
    }

    @Override
    public void setDefaultCollectionType(SequenceType type) {
        this.defaultCollectionType = type;
    }

    @Override
    public void setOption(QName name, String value) {
        this.options.put(name, value);
    }

    @Override
    public String getOption(QName name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name);
        }
        if (this.parent != null) {
            return this.parent.getOption(name);
        }
        return null;
    }

    @Override
    public IStaticContextFactory createFactory() {
        return StaticContextImplFactory.createInstance(this);
    }

    private abstract class ConcatenatingIterator<T>
    implements Iterator<T> {
        Iterator<T> currListIter = this.getCurrentIterator();
        Iterator<T> parentIter = null;
        T nextItem = null;

        private ConcatenatingIterator() {
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return this.nextItem != null;
        }

        protected abstract Iterator<T> getCurrentIterator();

        protected abstract Iterator<T> getParentIterator();

        @Override
        public T next() {
            if (this.hasNext()) {
                T item = this.nextItem;
                this.nextItem = null;
                return item;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchNext() {
            if (this.nextItem != null) {
                return;
            }
            if (this.currListIter != null) {
                if (this.currListIter.hasNext()) {
                    this.nextItem = this.currListIter.next();
                } else {
                    this.currListIter = null;
                    this.parentIter = this.getParentIterator();
                }
            }
            if (this.nextItem == null && this.parentIter != null) {
                if (this.parentIter.hasNext()) {
                    this.nextItem = this.parentIter.next();
                } else {
                    this.parentIter = null;
                }
            }
        }
    }
}

