/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.context;

import edu.uci.ics.hyracks.api.context.IHyracksJobletContext;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.util.Arrays;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.context.DynamicContextImpl;
import org.apache.vxquery.context.IDynamicContextFactory;
import org.apache.vxquery.context.IStaticContextFactory;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;

class DynamicContextImplFactory
implements IDynamicContextFactory {
    private static final long serialVersionUID = 1L;
    private final IStaticContextFactory scFactory;
    private final byte[] currentDateTime;
    private final QName[] variableNames;
    private final int[] valueOffsets;
    private final byte[] variableValues;

    private DynamicContextImplFactory(IStaticContextFactory scFactory, byte[] currentDateTime, QName[] variableNames, int[] valueOffsets, byte[] variableValues) {
        this.scFactory = scFactory;
        this.currentDateTime = currentDateTime;
        this.variableNames = variableNames;
        this.valueOffsets = valueOffsets;
        this.variableValues = variableValues;
    }

    @Override
    public DynamicContext createDynamicContext(IHyracksJobletContext ctx) {
        StaticContext sCtx = this.scFactory.createStaticContext();
        DynamicContextImpl dCtx = new DynamicContextImpl(sCtx);
        VoidPointable vp = new VoidPointable();
        vp.set(this.currentDateTime, 0, this.currentDateTime.length);
        dCtx.setCurrentDateTime((IValueReference)vp);
        for (int i = 0; i < this.variableNames.length; ++i) {
            QName vName = this.variableNames[i];
            int vStart = i == 0 ? 0 : this.valueOffsets[i - 1];
            int vEnd = this.valueOffsets[i];
            vp.set(this.variableValues, vStart, vEnd - vStart);
            dCtx.bindVariable(vName, (IValueReference)vp);
        }
        return dCtx;
    }

    static IDynamicContextFactory createInstance(DynamicContextImpl dCtx) {
        IStaticContextFactory scFactory = dCtx.getStaticContext().createFactory();
        int dtLen = XSDateTimePointable.TYPE_TRAITS.getFixedLength();
        byte[] currentDateTime = new byte[dtLen];
        XSDateTimePointable datetimep = new XSDateTimePointable();
        datetimep.set(currentDateTime, 0, dtLen);
        datetimep.setCurrentDateTime();
        Map<QName, ArrayBackedValueStorage> vMap = dCtx.getVariableMap();
        int nVars = vMap.size();
        QName[] variableNames = new QName[nVars];
        int[] valueOffsets = new int[nVars];
        ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        int i = 0;
        for (Map.Entry<QName, ArrayBackedValueStorage> e : vMap.entrySet()) {
            variableNames[i] = e.getKey();
            abvs.append((IValueReference)e.getValue());
            valueOffsets[i] = abvs.getLength();
            ++i;
        }
        return new DynamicContextImplFactory(scFactory, currentDateTime, variableNames, valueOffsets, Arrays.copyOfRange(abvs.getByteArray(), abvs.getStartOffset(), abvs.getLength()));
    }
}

