/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.context;

import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.context.DynamicContextImplFactory;
import org.apache.vxquery.context.IDynamicContextFactory;
import org.apache.vxquery.context.StaticContext;

public class DynamicContextImpl
implements DynamicContext {
    private StaticContext sCtx;
    private final Map<QName, ArrayBackedValueStorage> variables;
    private byte[] currentDateTime;

    public DynamicContextImpl(StaticContext sCtx) {
        this.sCtx = sCtx;
        this.variables = new HashMap<QName, ArrayBackedValueStorage>();
    }

    @Override
    public IDynamicContextFactory createFactory() {
        return DynamicContextImplFactory.createInstance(this);
    }

    @Override
    public StaticContext getStaticContext() {
        return this.sCtx;
    }

    @Override
    public void setCurrentDateTime(IValueReference value) {
        if (this.currentDateTime == null) {
            this.currentDateTime = new byte[value.getLength()];
        }
        System.arraycopy(value.getByteArray(), value.getStartOffset(), this.currentDateTime, 0, value.getLength());
    }

    @Override
    public void getCurrentDateTime(IPointable value) {
        value.set(this.currentDateTime, 0, this.currentDateTime.length);
    }

    @Override
    public void bindVariable(QName var, IValueReference value) {
        ArrayBackedValueStorage abvs = this.variables.get(var);
        if (abvs == null) {
            abvs = new ArrayBackedValueStorage();
            this.variables.put(var, abvs);
        }
        abvs.assign(value);
    }

    @Override
    public void lookupVariable(QName var, IPointable value) {
        ArrayBackedValueStorage abvs = this.variables.get(var);
        if (abvs == null) {
            value.set(null, -1, -1);
        } else {
            value.set((IValueReference)abvs);
        }
    }

    Map<QName, ArrayBackedValueStorage> getVariableMap() {
        return this.variables;
    }
}

