/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules.util;

import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class OperatorToolbox {
    public static Mutable<ILogicalOperator> findLastSubplanOperator(Mutable<ILogicalOperator> opRef) {
        AbstractLogicalOperator next;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef;
        while (op.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE && (next = (AbstractLogicalOperator)((Mutable)(op = (AbstractLogicalOperator)(opRef = (Mutable)op.getInputs().get(0))).getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
        }
        return opRef;
    }

    public static AbstractLogicalOperator findLastSubplanOperator(AbstractLogicalOperator op) {
        AbstractLogicalOperator next;
        while (op.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE && (next = (AbstractLogicalOperator)((Mutable)(op = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
        }
        return op;
    }

    public static List<Mutable<ILogicalExpression>> getExpressions(Mutable<ILogicalOperator> opRef) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        ArrayList<Mutable<ILogicalExpression>> result = new ArrayList<Mutable<ILogicalExpression>>();
        switch (op.getOperatorTag()) {
            case AGGREGATE: 
            case ASSIGN: 
            case RUNNINGAGGREGATE: {
                AbstractAssignOperator aao = (AbstractAssignOperator)op;
                result.addAll(aao.getExpressions());
                break;
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                AbstractBinaryJoinOperator abjo = (AbstractBinaryJoinOperator)op;
                result.add((Mutable<ILogicalExpression>)abjo.getCondition());
                break;
            }
            case SELECT: {
                SelectOperator so = (SelectOperator)op;
                result.add((Mutable<ILogicalExpression>)so.getCondition());
                break;
            }
            case UNNEST: 
            case UNNEST_MAP: {
                AbstractUnnestOperator auo = (AbstractUnnestOperator)op;
                result.add((Mutable<ILogicalExpression>)auo.getExpressionRef());
                break;
            }
        }
        return result;
    }

    public static Mutable<ILogicalExpression> getExpressionOf(Mutable<ILogicalOperator> opRef, LogicalVariable lv) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case AGGREGATE: 
            case ASSIGN: 
            case RUNNINGAGGREGATE: {
                AbstractAssignOperator aao = (AbstractAssignOperator)op;
                if (!aao.getVariables().contains(lv)) {
                    return null;
                }
                return (Mutable)aao.getExpressions().get(aao.getVariables().indexOf(lv));
            }
            case UNNEST: 
            case UNNEST_MAP: {
                AbstractUnnestOperator ano = (AbstractUnnestOperator)op;
                return ano.getExpressionRef();
            }
        }
        return null;
    }

    public static Mutable<ILogicalOperator> findProducerOf(Mutable<ILogicalOperator> opRef, LogicalVariable lv) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case AGGREGATE: 
            case ASSIGN: 
            case RUNNINGAGGREGATE: {
                AbstractAssignOperator aao = (AbstractAssignOperator)op;
                if (aao.getVariables().contains(lv)) {
                    return opRef;
                }
                for (Mutable input : op.getInputs()) {
                    Mutable<ILogicalOperator> opInput = OperatorToolbox.findProducerOf((Mutable<ILogicalOperator>)input, lv);
                    if (opInput == null) continue;
                    return opInput;
                }
                break;
            }
            case UNNEST: 
            case UNNEST_MAP: 
            case DATASOURCESCAN: {
                AbstractScanOperator aso = (AbstractScanOperator)op;
                if (aso.getVariables().contains(lv)) {
                    return opRef;
                }
                for (Mutable input : op.getInputs()) {
                    Mutable<ILogicalOperator> opInput = OperatorToolbox.findProducerOf((Mutable<ILogicalOperator>)input, lv);
                    if (opInput == null) continue;
                    return opInput;
                }
                break;
            }
            case EMPTYTUPLESOURCE: 
            case NESTEDTUPLESOURCE: {
                return null;
            }
            default: {
                for (Mutable input : op.getInputs()) {
                    Mutable<ILogicalOperator> opInput = OperatorToolbox.findProducerOf((Mutable<ILogicalOperator>)input, lv);
                    if (opInput == null) continue;
                    return opInput;
                }
            }
        }
        return null;
    }
}

