/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules.util;

import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.algebricks.VXQueryConstantValue;
import org.apache.vxquery.compiler.rewriter.rules.util.OperatorToolbox;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.functions.BuiltinFunctions;
import org.apache.vxquery.functions.BuiltinOperators;
import org.apache.vxquery.functions.Function;
import org.apache.vxquery.types.AnyNodeType;
import org.apache.vxquery.types.Quantifier;
import org.apache.vxquery.types.SequenceType;

public class ExpressionToolbox {
    public static Mutable<ILogicalExpression> findVariableExpression(Mutable<ILogicalExpression> mutableLe, LogicalVariable lv) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            VariableReferenceExpression vre = (VariableReferenceExpression)le;
            if (vre.getVariableReference() == lv) {
                return mutableLe;
            }
        } else if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            for (Mutable argExp : afce.getArguments()) {
                Mutable<ILogicalExpression> resultLe = ExpressionToolbox.findVariableExpression((Mutable<ILogicalExpression>)argExp, lv);
                if (resultLe == null) continue;
                return resultLe;
            }
        }
        return null;
    }

    public static Mutable<ILogicalExpression> findVariableExpression(Mutable<ILogicalExpression> mutableLe) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return mutableLe;
        }
        if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            for (Mutable argExp : afce.getArguments()) {
                Mutable<ILogicalExpression> resultLe = ExpressionToolbox.findVariableExpression((Mutable<ILogicalExpression>)argExp);
                if (resultLe == null) continue;
                return resultLe;
            }
        }
        return null;
    }

    public static void findVariableExpressions(Mutable<ILogicalExpression> mutableLe, List<Mutable<ILogicalExpression>> finds) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            finds.add(mutableLe);
        } else if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            for (Mutable argExp : afce.getArguments()) {
                ExpressionToolbox.findVariableExpressions((Mutable<ILogicalExpression>)argExp, finds);
            }
        }
    }

    public static Mutable<ILogicalExpression> findLastFunctionExpression(Mutable<ILogicalExpression> mutableLe) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return null;
        }
        if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            for (Mutable argExp : afce.getArguments()) {
                if (((ILogicalExpression)argExp.getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                    return mutableLe;
                }
                Mutable<ILogicalExpression> resultLe = ExpressionToolbox.findLastFunctionExpression((Mutable<ILogicalExpression>)argExp);
                if (resultLe == null) continue;
                return resultLe;
            }
        }
        return null;
    }

    public static Mutable<ILogicalExpression> findFirstFunctionExpression(Mutable<ILogicalExpression> mutableLe, FunctionIdentifier fi) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            if (afce.getFunctionIdentifier().equals((Object)fi)) {
                return mutableLe;
            }
            for (Mutable argExp : afce.getArguments()) {
                Mutable<ILogicalExpression> resultLe = ExpressionToolbox.findFirstFunctionExpression((Mutable<ILogicalExpression>)argExp, fi);
                if (resultLe == null) continue;
                return resultLe;
            }
        }
        return null;
    }

    public static void findAllFunctionExpressions(Mutable<ILogicalExpression> mutableLe, FunctionIdentifier fi, List<Mutable<ILogicalExpression>> finds) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            if (afce.getFunctionIdentifier().equals((Object)fi)) {
                finds.add(mutableLe);
            }
            for (Mutable argExp : afce.getArguments()) {
                ExpressionToolbox.findAllFunctionExpressions((Mutable<ILogicalExpression>)argExp, fi, finds);
            }
        }
    }

    public static Function getBuiltIn(Mutable<ILogicalExpression> mutableLe) {
        ILogicalExpression le = (ILogicalExpression)mutableLe.getValue();
        if (le.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
            AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)le;
            for (Function function : BuiltinFunctions.FUNCTION_COLLECTION) {
                if (!function.getFunctionIdentifier().equals((Object)afce.getFunctionIdentifier())) continue;
                return function;
            }
            for (Function function : BuiltinOperators.OPERATOR_COLLECTION) {
                if (!function.getFunctionIdentifier().equals((Object)afce.getFunctionIdentifier())) continue;
                return function;
            }
        }
        return null;
    }

    public static void getConstantAsPointable(ConstantExpression typeExpression, TaggedValuePointable tvp) {
        VXQueryConstantValue treatTypeConstant = (VXQueryConstantValue)typeExpression.getValue();
        tvp.set(treatTypeConstant.getValue(), 0, treatTypeConstant.getValue().length);
    }

    public static int getTypeExpressionTypeArgument(Mutable<ILogicalExpression> searchM) {
        boolean ARG_TYPE = true;
        AbstractFunctionCallExpression searchFunction = (AbstractFunctionCallExpression)searchM.getValue();
        ILogicalExpression argType = (ILogicalExpression)((Mutable)searchFunction.getArguments().get(1)).getValue();
        if (argType.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return -1;
        }
        TaggedValuePointable tvp = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        ExpressionToolbox.getConstantAsPointable((ConstantExpression)argType, tvp);
        IntegerPointable pTypeCode = (IntegerPointable)IntegerPointable.FACTORY.createPointable();
        tvp.getValue((IPointable)pTypeCode);
        return pTypeCode.getInteger();
    }

    public static SequenceType getTypeExpressionTypeArgument(Mutable<ILogicalExpression> searchM, StaticContext dCtx) {
        int typeId = ExpressionToolbox.getTypeExpressionTypeArgument(searchM);
        if (typeId > 0) {
            return dCtx.lookupSequenceType(typeId);
        }
        return null;
    }

    public static SequenceType getOutputSequenceType(Mutable<ILogicalOperator> opRef, Mutable<ILogicalExpression> argFirstM, StaticContext dCtx) {
        ILogicalExpression argFirstLe = (ILogicalExpression)argFirstM.getValue();
        switch (argFirstLe.getExpressionTag()) {
            case FUNCTION_CALL: {
                Function function = ExpressionToolbox.getBuiltIn(argFirstM);
                if (function == null) {
                    return null;
                }
                if (function.getFunctionIdentifier().equals((Object)BuiltinOperators.CAST.getFunctionIdentifier())) {
                    return ExpressionToolbox.getTypeExpressionTypeArgument(argFirstM, dCtx);
                }
                return function.getSignature().getReturnType();
            }
            case CONSTANT: {
                ConstantExpression constantExpression = (ConstantExpression)argFirstLe;
                VXQueryConstantValue constantValue = (VXQueryConstantValue)constantExpression.getValue();
                return constantValue.getType();
            }
            case VARIABLE: {
                VariableReferenceExpression variableRefExp = (VariableReferenceExpression)argFirstLe;
                LogicalVariable variableId = variableRefExp.getVariableReference();
                Mutable<ILogicalOperator> variableProducer = OperatorToolbox.findProducerOf(opRef, variableId);
                if (variableProducer == null) {
                    return null;
                }
                AbstractLogicalOperator variableOp = (AbstractLogicalOperator)variableProducer.getValue();
                switch (variableOp.getOperatorTag()) {
                    case DATASOURCESCAN: {
                        return SequenceType.create(AnyNodeType.INSTANCE, Quantifier.QUANT_ONE);
                    }
                    case UNNEST: {
                        UnnestOperator unnest = (UnnestOperator)variableOp;
                        return ExpressionToolbox.getOutputSequenceType(variableProducer, (Mutable<ILogicalExpression>)unnest.getExpressionRef(), dCtx);
                    }
                }
            }
        }
        return null;
    }
}

