/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules.util;

import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.rewriter.VXQueryOptimizationContext;
import org.apache.vxquery.compiler.rewriter.rules.propagationpolicies.cardinality.Cardinality;

public class CardinalityRuleToolbox {
    public static Cardinality getProducerCardinality(ILogicalOperator op, VXQueryOptimizationContext vxqueryContext) {
        AbstractLogicalOperator producerOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        switch (producerOp.getOperatorTag()) {
            case EMPTYTUPLESOURCE: {
                return Cardinality.ONE;
            }
            case NESTEDTUPLESOURCE: {
                NestedTupleSourceOperator nestedTuplesource = (NestedTupleSourceOperator)producerOp;
                return CardinalityRuleToolbox.getProducerCardinality((ILogicalOperator)nestedTuplesource.getDataSourceReference().getValue(), vxqueryContext);
            }
        }
        return vxqueryContext.getCardinalityOperatorMap((ILogicalOperator)producerOp);
    }

    public static Cardinality updateCardinalityVariable(AbstractLogicalOperator op, Cardinality cardinalityVariable, VXQueryOptimizationContext vxqueryContext) {
        switch (op.getOperatorTag()) {
            case AGGREGATE: {
                cardinalityVariable = Cardinality.ONE;
                break;
            }
            case GROUP: 
            case SUBPLAN: {
                AbstractOperatorWithNestedPlans operatorWithNestedPlan = (AbstractOperatorWithNestedPlans)op;
                AbstractLogicalOperator lastOperator = (AbstractLogicalOperator)((Mutable)((ILogicalPlan)operatorWithNestedPlan.getNestedPlans().get(0)).getRoots().get(0)).getValue();
                cardinalityVariable = vxqueryContext.getCardinalityOperatorMap((ILogicalOperator)lastOperator);
                break;
            }
            case DATASOURCESCAN: 
            case INNERJOIN: 
            case LEFTOUTERJOIN: 
            case UNNEST: {
                cardinalityVariable = Cardinality.MANY;
                break;
            }
            case EMPTYTUPLESOURCE: 
            case NESTEDTUPLESOURCE: 
            case ASSIGN: 
            case DISTRIBUTE_RESULT: 
            case EXCHANGE: 
            case LIMIT: 
            case ORDER: 
            case PROJECT: 
            case SELECT: 
            case WRITE: 
            case WRITE_RESULT: {
                break;
            }
            default: {
                throw new RuntimeException("Operator (" + op.getOperatorTag() + ") has not been implemented in rewrite rule.");
            }
        }
        return cardinalityVariable;
    }
}

