/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.commons.lang3.mutable.Mutable;

public class SetVariableIdContextRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        int variableId = 0;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case ASSIGN: 
            case AGGREGATE: {
                AbstractAssignOperator assign = (AbstractAssignOperator)op;
                variableId = ((LogicalVariable)assign.getVariables().get(0)).getId();
                break;
            }
            case UNNEST: {
                UnnestOperator unnest = (UnnestOperator)op;
                variableId = unnest.getVariable().getId();
                break;
            }
            default: {
                return false;
            }
        }
        if (context.getVarCounter() <= variableId) {
            context.setVarCounter(variableId + 1);
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue());
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

