/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.rewriter.VXQueryOptimizationContext;
import org.apache.vxquery.compiler.rewriter.rules.propagationpolicies.cardinality.Cardinality;
import org.apache.vxquery.compiler.rewriter.rules.propagationpolicies.documentorder.DocumentOrder;
import org.apache.vxquery.compiler.rewriter.rules.propagationpolicies.uniquenodes.UniqueNodes;
import org.apache.vxquery.compiler.rewriter.rules.util.CardinalityRuleToolbox;
import org.apache.vxquery.functions.BuiltinOperators;
import org.apache.vxquery.functions.Function;

public class RemoveUnusedSortDistinctNodesRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        boolean operatorChanged = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE || op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        VXQueryOptimizationContext vxqueryContext = (VXQueryOptimizationContext)context;
        Cardinality cardinalityVariable = CardinalityRuleToolbox.getProducerCardinality((ILogicalOperator)opRef.getValue(), vxqueryContext);
        HashMap<Integer, DocumentOrder> documentOrderVariables = this.getProducerDocumentOrderVariableMap((ILogicalOperator)opRef.getValue(), vxqueryContext);
        HashMap<Integer, UniqueNodes> uniqueNodesVariables = this.getProducerUniqueNodesVariableMap((ILogicalOperator)opRef.getValue(), vxqueryContext);
        int variableId = this.getOperatorSortDistinctNodesAscOrAtomicsArgumentVariableId(opRef);
        if (variableId > 0) {
            AssignOperator assign = (AssignOperator)op;
            ILogicalExpression logicalExpression = (ILogicalExpression)((Mutable)assign.getExpressions().get(0)).getValue();
            AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)logicalExpression;
            if (uniqueNodesVariables.get(variableId) == UniqueNodes.YES) {
                if (documentOrderVariables.get(variableId) == DocumentOrder.YES) {
                    ((Mutable)assign.getExpressions().get(0)).setValue(((Mutable)functionCall.getArguments().get(0)).getValue());
                    operatorChanged = true;
                } else {
                    functionCall.setFunctionInfo((IFunctionInfo)BuiltinOperators.SORT_NODES_ASC);
                    operatorChanged = true;
                }
            } else if (documentOrderVariables.get(variableId) == DocumentOrder.YES) {
                functionCall.setFunctionInfo((IFunctionInfo)BuiltinOperators.DISTINCT_NODES_OR_ATOMICS);
                operatorChanged = true;
            }
        }
        cardinalityVariable = CardinalityRuleToolbox.updateCardinalityVariable(op, cardinalityVariable, vxqueryContext);
        this.updateVariableMap(op, cardinalityVariable, documentOrderVariables, uniqueNodesVariables, vxqueryContext);
        vxqueryContext.putCardinalityOperatorMap((ILogicalOperator)opRef.getValue(), cardinalityVariable);
        vxqueryContext.putDocumentOrderOperatorVariableMap((ILogicalOperator)opRef.getValue(), documentOrderVariables);
        vxqueryContext.putUniqueNodesOperatorVariableMap((ILogicalOperator)opRef.getValue(), uniqueNodesVariables);
        return operatorChanged;
    }

    private int getOperatorSortDistinctNodesAscOrAtomicsArgumentVariableId(Mutable<ILogicalOperator> opRef) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return 0;
        }
        AssignOperator assign = (AssignOperator)op;
        ILogicalExpression logicalExpression = (ILogicalExpression)((Mutable)assign.getExpressions().get(0)).getValue();
        if (logicalExpression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return 0;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)logicalExpression;
        if (!functionCall.getFunctionIdentifier().equals((Object)BuiltinOperators.SORT_DISTINCT_NODES_ASC_OR_ATOMICS.getFunctionIdentifier())) {
            return 0;
        }
        ILogicalExpression logicalExpression2 = (ILogicalExpression)((Mutable)functionCall.getArguments().get(0)).getValue();
        if (logicalExpression2.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return 0;
        }
        VariableReferenceExpression variableExpression = (VariableReferenceExpression)logicalExpression2;
        return variableExpression.getVariableReference().getId();
    }

    private HashMap<Integer, DocumentOrder> getProducerDocumentOrderVariableMap(ILogicalOperator op, VXQueryOptimizationContext vxqueryContext) {
        AbstractLogicalOperator producerOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        switch (producerOp.getOperatorTag()) {
            case EMPTYTUPLESOURCE: {
                return new HashMap<Integer, DocumentOrder>();
            }
            case NESTEDTUPLESOURCE: {
                NestedTupleSourceOperator nestedTuplesource = (NestedTupleSourceOperator)producerOp;
                return this.getProducerDocumentOrderVariableMap((ILogicalOperator)nestedTuplesource.getDataSourceReference().getValue(), vxqueryContext);
            }
        }
        return new HashMap<Integer, DocumentOrder>(vxqueryContext.getDocumentOrderOperatorVariableMap((ILogicalOperator)producerOp));
    }

    private HashMap<Integer, UniqueNodes> getProducerUniqueNodesVariableMap(ILogicalOperator op, VXQueryOptimizationContext vxqueryContext) {
        AbstractLogicalOperator producerOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        switch (producerOp.getOperatorTag()) {
            case EMPTYTUPLESOURCE: {
                return new HashMap<Integer, UniqueNodes>();
            }
            case NESTEDTUPLESOURCE: {
                NestedTupleSourceOperator nestedTuplesource = (NestedTupleSourceOperator)producerOp;
                return this.getProducerUniqueNodesVariableMap((ILogicalOperator)nestedTuplesource.getDataSourceReference().getValue(), vxqueryContext);
            }
        }
        return new HashMap<Integer, UniqueNodes>(vxqueryContext.getUniqueNodesOperatorVariableMap((ILogicalOperator)producerOp));
    }

    private DocumentOrder propagateDocumentOrder(ILogicalExpression expr, HashMap<Integer, DocumentOrder> variableMap) {
        DocumentOrder documentOrder = null;
        switch (expr.getExpressionTag()) {
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)expr;
                ArrayList<DocumentOrder> argProperties = new ArrayList<DocumentOrder>();
                for (Mutable argExpr : functionCall.getArguments()) {
                    argProperties.add(this.propagateDocumentOrder((ILogicalExpression)argExpr.getValue(), variableMap));
                }
                Function func = (Function)functionCall.getFunctionInfo();
                documentOrder = func.getDocumentOrderPropagationPolicy().propagate(argProperties);
                break;
            }
            case VARIABLE: {
                VariableReferenceExpression variableReference = (VariableReferenceExpression)expr;
                int argVariableId = variableReference.getVariableReference().getId();
                documentOrder = variableMap.get(argVariableId);
                break;
            }
            default: {
                documentOrder = DocumentOrder.YES;
            }
        }
        return documentOrder;
    }

    private UniqueNodes propagateUniqueNodes(ILogicalExpression expr, HashMap<Integer, UniqueNodes> variableMap) {
        UniqueNodes uniqueNodes = null;
        switch (expr.getExpressionTag()) {
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)expr;
                ArrayList<UniqueNodes> argProperties = new ArrayList<UniqueNodes>();
                for (Mutable argExpr : functionCall.getArguments()) {
                    argProperties.add(this.propagateUniqueNodes((ILogicalExpression)argExpr.getValue(), variableMap));
                }
                Function func = (Function)functionCall.getFunctionInfo();
                uniqueNodes = func.getUniqueNodesPropagationPolicy().propagate(argProperties);
                break;
            }
            case VARIABLE: {
                VariableReferenceExpression variableReference = (VariableReferenceExpression)expr;
                int argVariableId = variableReference.getVariableReference().getId();
                uniqueNodes = variableMap.get(argVariableId);
                break;
            }
            default: {
                uniqueNodes = UniqueNodes.YES;
            }
        }
        return uniqueNodes;
    }

    private void resetDocumentOrderVariables(HashMap<Integer, DocumentOrder> documentOrderVariables, DocumentOrder documentOrder) {
        for (Map.Entry<Integer, DocumentOrder> entry : documentOrderVariables.entrySet()) {
            documentOrderVariables.put(entry.getKey(), documentOrder);
        }
    }

    private void resetUniqueNodesVariables(HashMap<Integer, UniqueNodes> uniqueNodesVariables, UniqueNodes uniqueNodes) {
        for (Map.Entry<Integer, UniqueNodes> entry : uniqueNodesVariables.entrySet()) {
            uniqueNodesVariables.put(entry.getKey(), uniqueNodes);
        }
    }

    private void updateVariableMap(AbstractLogicalOperator op, Cardinality cardinalityVariable, HashMap<Integer, DocumentOrder> documentOrderVariables, HashMap<Integer, UniqueNodes> uniqueNodesVariables, VXQueryOptimizationContext vxqueryContext) {
        HashMap<Integer, DocumentOrder> documentOrderVariablesForOperator = this.getProducerDocumentOrderVariableMap((ILogicalOperator)op, vxqueryContext);
        HashMap<Integer, UniqueNodes> uniqueNodesVariablesForOperator = this.getProducerUniqueNodesVariableMap((ILogicalOperator)op, vxqueryContext);
        switch (op.getOperatorTag()) {
            case AGGREGATE: {
                AggregateOperator aggregate = (AggregateOperator)op;
                for (int index = 0; index < aggregate.getExpressions().size(); ++index) {
                    ILogicalExpression aggregateLogicalExpression = (ILogicalExpression)((Mutable)aggregate.getExpressions().get(index)).getValue();
                    int variableId = ((LogicalVariable)aggregate.getVariables().get(index)).getId();
                    DocumentOrder documentOrder = this.propagateDocumentOrder(aggregateLogicalExpression, documentOrderVariablesForOperator);
                    UniqueNodes uniqueNodes = this.propagateUniqueNodes(aggregateLogicalExpression, uniqueNodesVariablesForOperator);
                    documentOrderVariables.put(variableId, documentOrder);
                    uniqueNodesVariables.put(variableId, uniqueNodes);
                }
                break;
            }
            case ASSIGN: {
                AssignOperator assign = (AssignOperator)op;
                for (int index = 0; index < assign.getExpressions().size(); ++index) {
                    ILogicalExpression assignLogicalExpression = (ILogicalExpression)((Mutable)assign.getExpressions().get(index)).getValue();
                    int variableId = ((LogicalVariable)assign.getVariables().get(index)).getId();
                    DocumentOrder documentOrder = this.propagateDocumentOrder(assignLogicalExpression, documentOrderVariablesForOperator);
                    UniqueNodes uniqueNodes = this.propagateUniqueNodes(assignLogicalExpression, uniqueNodesVariablesForOperator);
                    documentOrderVariables.put(variableId, documentOrder);
                    uniqueNodesVariables.put(variableId, uniqueNodes);
                }
                break;
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                this.resetDocumentOrderVariables(documentOrderVariables, DocumentOrder.NO);
                this.resetUniqueNodesVariables(uniqueNodesVariables, UniqueNodes.NO);
                break;
            }
            case ORDER: {
                OrderOperator order = (OrderOperator)op;
                for (int index = 0; index < order.getOrderExpressions().size(); ++index) {
                    ILogicalExpression orderLogicalExpression = (ILogicalExpression)((Mutable)((Pair)order.getOrderExpressions().get((int)index)).second).getValue();
                    if (orderLogicalExpression.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                        throw new RuntimeException("Operator (" + op.getOperatorTag() + ") has received unexpected input in rewrite rule.");
                    }
                    VariableReferenceExpression variableExpression = (VariableReferenceExpression)orderLogicalExpression;
                    int variableId = variableExpression.getVariableReference().getId();
                    documentOrderVariables.put(variableId, DocumentOrder.NO);
                }
                break;
            }
            case SUBPLAN: {
                SubplanOperator subplan = (SubplanOperator)op;
                for (int index = 0; index < subplan.getNestedPlans().size(); ++index) {
                    AbstractLogicalOperator lastOperator = (AbstractLogicalOperator)((Mutable)((ILogicalPlan)subplan.getNestedPlans().get(index)).getRoots().get(0)).getValue();
                    this.updateVariableMap(lastOperator, cardinalityVariable, documentOrderVariables, uniqueNodesVariables, vxqueryContext);
                }
                break;
            }
            case UNNEST: {
                UnnestOperator unnest = (UnnestOperator)op;
                ILogicalExpression unnestLogicalExpression = (ILogicalExpression)unnest.getExpressionRef().getValue();
                int variableId = ((LogicalVariable)unnest.getVariables().get(0)).getId();
                Cardinality inputCardinality = vxqueryContext.getCardinalityOperatorMap((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue());
                DocumentOrder documentOrder = this.propagateDocumentOrder(unnestLogicalExpression, documentOrderVariablesForOperator);
                UniqueNodes uniqueNodes = this.propagateUniqueNodes(unnestLogicalExpression, uniqueNodesVariablesForOperator);
                this.resetDocumentOrderVariables(documentOrderVariables, DocumentOrder.NO);
                this.resetUniqueNodesVariables(uniqueNodesVariables, UniqueNodes.NO);
                if (inputCardinality == Cardinality.ONE) {
                    documentOrderVariables.put(variableId, documentOrder);
                    uniqueNodesVariables.put(variableId, uniqueNodes);
                } else {
                    documentOrderVariables.put(variableId, DocumentOrder.NO);
                    uniqueNodesVariables.put(variableId, UniqueNodes.NO);
                }
                if (unnest.getPositionalVariable() == null) break;
                variableId = unnest.getPositionalVariable().getId();
                if (inputCardinality == Cardinality.ONE) {
                    documentOrderVariables.put(variableId, DocumentOrder.YES);
                    uniqueNodesVariables.put(variableId, UniqueNodes.YES);
                    break;
                }
                documentOrderVariables.put(variableId, DocumentOrder.NO);
                uniqueNodesVariables.put(variableId, UniqueNodes.NO);
                break;
            }
            case EMPTYTUPLESOURCE: 
            case NESTEDTUPLESOURCE: 
            case DATASOURCESCAN: 
            case DISTRIBUTE_RESULT: 
            case EXCHANGE: 
            case PROJECT: 
            case SELECT: 
            case WRITE: 
            case WRITE_RESULT: {
                break;
            }
            default: {
                throw new RuntimeException("Operator (" + op.getOperatorTag() + ") has not been implemented in rewrite rule.");
            }
        }
    }
}

