/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.vxquery.compiler.rewriter.rules.util.ExpressionToolbox;

public class PushFunctionsOntoEqJoinBranches
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
        ILogicalExpression expr = (ILogicalExpression)join.getCondition().getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (!fi.equals((Object)AlgebricksBuiltinFunctions.AND) && !fi.equals((Object)AlgebricksBuiltinFunctions.EQ)) {
            return false;
        }
        boolean modified = false;
        ArrayList<Mutable<ILogicalExpression>> functionList = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<Mutable<ILogicalExpression>> variableList = new ArrayList<Mutable<ILogicalExpression>>();
        functionList.clear();
        ExpressionToolbox.findAllFunctionExpressions((Mutable<ILogicalExpression>)join.getCondition(), AlgebricksBuiltinFunctions.EQ, functionList);
        ArrayList<LogicalVariable> producedVariables = new ArrayList<LogicalVariable>();
        for (Mutable mutable : functionList) {
            ILogicalExpression search = (ILogicalExpression)mutable.getValue();
            if (search.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression searchExp = (AbstractFunctionCallExpression)search;
            for (Mutable expressionM : searchExp.getArguments()) {
                for (Mutable branch : join.getInputs()) {
                    producedVariables.clear();
                    PushFunctionsOntoEqJoinBranches.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)branch.getValue(), producedVariables);
                    variableList.clear();
                    ExpressionToolbox.findVariableExpressions((Mutable<ILogicalExpression>)expressionM, variableList);
                    boolean found = true;
                    for (Mutable mutable2 : variableList) {
                        VariableReferenceExpression vre = (VariableReferenceExpression)mutable2.getValue();
                        if (producedVariables.contains(vre.getVariableReference())) continue;
                        found = false;
                    }
                    if (!found) continue;
                    LogicalVariable assignVariable = context.newVar();
                    AssignOperator assignOperator = new AssignOperator(assignVariable, (Mutable)new MutableObject(expressionM.getValue()));
                    assignOperator.getInputs().add(new MutableObject(branch.getValue()));
                    branch.setValue((Object)assignOperator);
                    assignOperator.recomputeSchema();
                    expressionM.setValue((Object)new VariableReferenceExpression(assignVariable));
                    modified = true;
                }
            }
        }
        return modified;
    }

    public static void getProducedVariablesInDescendantsAndSelf(ILogicalOperator op, Collection<LogicalVariable> vars) throws AlgebricksException {
        VariableUtilities.getProducedVariables((ILogicalOperator)op, vars);
        for (Mutable c : op.getInputs()) {
            PushFunctionsOntoEqJoinBranches.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)c.getValue(), vars);
        }
    }
}

