/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.functions.BuiltinFunctions;
import org.apache.vxquery.functions.BuiltinOperators;

public class IntroduceTwoStepAggregateRule
implements IAlgebraicRewriteRule {
    final Map<FunctionIdentifier, Pair<IFunctionInfo, IFunctionInfo>> AGGREGATE_MAP = new HashMap<FunctionIdentifier, Pair<IFunctionInfo, IFunctionInfo>>();

    public IntroduceTwoStepAggregateRule() {
        this.AGGREGATE_MAP.put(BuiltinFunctions.FN_AVG_1.getFunctionIdentifier(), (Pair<IFunctionInfo, IFunctionInfo>)new Pair((Object)BuiltinOperators.AVG_LOCAL, (Object)BuiltinOperators.AVG_GLOBAL));
        this.AGGREGATE_MAP.put(BuiltinFunctions.FN_COUNT_1.getFunctionIdentifier(), (Pair<IFunctionInfo, IFunctionInfo>)new Pair((Object)BuiltinFunctions.FN_COUNT_1, (Object)BuiltinFunctions.FN_SUM_1));
        this.AGGREGATE_MAP.put(BuiltinFunctions.FN_MAX_1.getFunctionIdentifier(), (Pair<IFunctionInfo, IFunctionInfo>)new Pair((Object)BuiltinFunctions.FN_MAX_1, (Object)BuiltinFunctions.FN_MAX_1));
        this.AGGREGATE_MAP.put(BuiltinFunctions.FN_MIN_1.getFunctionIdentifier(), (Pair<IFunctionInfo, IFunctionInfo>)new Pair((Object)BuiltinFunctions.FN_MIN_1, (Object)BuiltinFunctions.FN_MIN_1));
        this.AGGREGATE_MAP.put(BuiltinFunctions.FN_SUM_1.getFunctionIdentifier(), (Pair<IFunctionInfo, IFunctionInfo>)new Pair((Object)BuiltinFunctions.FN_SUM_1, (Object)BuiltinFunctions.FN_SUM_1));
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggregate = (AggregateOperator)op;
        Mutable mutableLogicalExpression = (Mutable)aggregate.getExpressions().get(0);
        ILogicalExpression logicalExpression = (ILogicalExpression)mutableLogicalExpression.getValue();
        if (logicalExpression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)logicalExpression;
        if (this.AGGREGATE_MAP.containsKey(functionCall.getFunctionIdentifier())) {
            AggregateFunctionCallExpression aggregateFunctionCall = (AggregateFunctionCallExpression)functionCall;
            if (aggregateFunctionCall.isTwoStep()) {
                return false;
            }
            aggregateFunctionCall.setTwoStep(true);
            aggregateFunctionCall.setStepOneAggregate((IFunctionInfo)this.AGGREGATE_MAP.get((Object)functionCall.getFunctionIdentifier()).first);
            aggregateFunctionCall.setStepTwoAggregate((IFunctionInfo)this.AGGREGATE_MAP.get((Object)functionCall.getFunctionIdentifier()).second);
            return true;
        }
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }
}

