/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import edu.uci.ics.hyracks.algebricks.rewriter.rules.InlineVariablesRule;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class InlineNestedVariablesRule
extends InlineVariablesRule {
    protected boolean inlineVariables(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            List vars = assignOp.getVariables();
            List exprs = assignOp.getExpressions();
            for (int i = 0; i < vars.size(); ++i) {
                AbstractFunctionCallExpression funcExpr;
                ILogicalExpression expr = (ILogicalExpression)((Mutable)exprs.get(i)).getValue();
                if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (this.doNotInlineFuncs.contains((funcExpr = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()) || !funcExpr.isFunctional())) continue;
                this.varAssignRhs.put(vars.get(i), ((Mutable)exprs.get(i)).getValue());
            }
        }
        boolean modified = false;
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nestedOp = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan nestedPlan : nestedOp.getNestedPlans()) {
                for (Mutable nestedOpRef : nestedPlan.getRoots()) {
                    if (!this.inlineVariables((Mutable<ILogicalOperator>)nestedOpRef, context)) continue;
                    modified = true;
                }
            }
        }
        for (Mutable inputOpRef : op.getInputs()) {
            if (!this.inlineVariables((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
            modified = true;
        }
        if (this.performBottomUpAction(op)) {
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
            context.removeFromAlreadyCompared((ILogicalOperator)opRef.getValue());
        }
        return modified;
    }
}

