/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.vxquery.compiler.rewriter.rules.util.ExpressionToolbox;
import org.apache.vxquery.compiler.rewriter.rules.util.OperatorToolbox;
import org.apache.vxquery.functions.BuiltinFunctions;
import org.apache.vxquery.functions.BuiltinOperators;

public class ConvertFromAlgebricksExpressionsRule
implements IAlgebraicRewriteRule {
    final List<Mutable<ILogicalExpression>> functionList = new ArrayList<Mutable<ILogicalExpression>>();
    final Map<FunctionIdentifier, IFunctionInfo> ALGEBRICKS_MAP = new HashMap<FunctionIdentifier, IFunctionInfo>();

    public ConvertFromAlgebricksExpressionsRule() {
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.AND, BuiltinOperators.AND);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.OR, BuiltinOperators.OR);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.NOT, BuiltinFunctions.FN_NOT_1);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.EQ, BuiltinOperators.VALUE_EQ);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.NEQ, BuiltinOperators.VALUE_NE);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.LT, BuiltinOperators.VALUE_LT);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.LE, BuiltinOperators.VALUE_LE);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.GT, BuiltinOperators.VALUE_GT);
        this.ALGEBRICKS_MAP.put(AlgebricksBuiltinFunctions.GE, BuiltinOperators.VALUE_GE);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean modified = false;
        List<Mutable<ILogicalExpression>> expressions = OperatorToolbox.getExpressions(opRef);
        for (Mutable<ILogicalExpression> expression : expressions) {
            if (!this.processExpression(opRef, expression)) continue;
            modified = true;
        }
        return modified;
    }

    private boolean processExpression(Mutable<ILogicalOperator> opRef, Mutable<ILogicalExpression> search) {
        boolean modified = false;
        for (FunctionIdentifier fid : this.ALGEBRICKS_MAP.keySet()) {
            this.functionList.clear();
            ExpressionToolbox.findAllFunctionExpressions(search, fid, this.functionList);
            for (Mutable<ILogicalExpression> searchM : this.functionList) {
                AbstractFunctionCallExpression searchFunction = (AbstractFunctionCallExpression)searchM.getValue();
                searchFunction.setFunctionInfo(this.ALGEBRICKS_MAP.get(fid));
                ScalarFunctionCallExpression booleanExp = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.FN_BOOLEAN_1, new Mutable[]{new MutableObject(searchM.getValue())});
                searchM.setValue((Object)booleanExp);
                modified = true;
            }
        }
        return modified;
    }
}

