/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.functions.BuiltinOperators;
import org.apache.vxquery.functions.Function;

public class ConvertAssignToUnnestRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)op;
        ILogicalExpression logicalExpression = (ILogicalExpression)unnest.getExpressionRef().getValue();
        if (logicalExpression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)logicalExpression;
        if (!functionCall.getFunctionIdentifier().equals((Object)BuiltinOperators.ITERATE.getFunctionIdentifier())) {
            return false;
        }
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)unnest.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assign = (AssignOperator)op2;
        ILogicalExpression logicalExpression2 = (ILogicalExpression)((Mutable)assign.getExpressions().get(0)).getValue();
        if (logicalExpression2.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression functionCall2 = (AbstractFunctionCallExpression)logicalExpression2;
        Function functionInfo2 = (Function)functionCall2.getFunctionInfo();
        if (!functionInfo2.hasUnnestingEvaluatorFactory()) {
            return false;
        }
        unnest.getInputs().clear();
        unnest.getInputs().addAll(assign.getInputs());
        UnnestingFunctionCallExpression child = new UnnestingFunctionCallExpression((IFunctionInfo)functionInfo2, functionCall2.getArguments());
        unnest.getExpressionRef().setValue((Object)child);
        return true;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }
}

