/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.vxquery.compiler.rewriter.rules.AbstractVXQueryAggregateRule;
import org.apache.vxquery.compiler.rewriter.rules.util.ExpressionToolbox;
import org.apache.vxquery.functions.BuiltinOperators;

public class ConvertAssignToAggregateRule
extends AbstractVXQueryAggregateRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assign = (AssignOperator)op;
        Mutable mutableLogicalExpression = (Mutable)assign.getExpressions().get(0);
        ILogicalExpression logicalExpression = (ILogicalExpression)mutableLogicalExpression.getValue();
        if (logicalExpression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression functionCall = (AbstractFunctionCallExpression)logicalExpression;
        IFunctionInfo aggregateInfo = this.getAggregateFunction(functionCall);
        if (aggregateInfo == null) {
            return false;
        }
        Mutable<ILogicalExpression> mutableVariableExpresion = ExpressionToolbox.findVariableExpression((Mutable<ILogicalExpression>)mutableLogicalExpression);
        if (mutableVariableExpresion == null) {
            return false;
        }
        Mutable<ILogicalExpression> finalFunctionCallM = ExpressionToolbox.findLastFunctionExpression((Mutable<ILogicalExpression>)mutableLogicalExpression);
        AbstractFunctionCallExpression finalFunctionCall = (AbstractFunctionCallExpression)finalFunctionCallM.getValue();
        Mutable<ILogicalOperator> inputOperator = this.getInputOperator((Mutable<ILogicalOperator>)((Mutable)assign.getInputs().get(0)));
        NestedTupleSourceOperator ntsOperator = new NestedTupleSourceOperator(inputOperator);
        MutableObject nextOperatorRef = new MutableObject((Object)ntsOperator);
        VariableReferenceExpression inputVariableRef = (VariableReferenceExpression)mutableVariableExpresion.getValue();
        LogicalVariable inputVariable = inputVariableRef.getVariableReference();
        LogicalVariable unnestVariable = context.newVar();
        UnnestOperator unnestOperator = this.getUnnestOperator(inputVariable, unnestVariable);
        unnestOperator.getInputs().add(nextOperatorRef);
        nextOperatorRef = new MutableObject((Object)unnestOperator);
        VariableReferenceExpression inputArg = new VariableReferenceExpression(unnestVariable);
        ((Mutable)finalFunctionCall.getArguments().get(0)).setValue((Object)inputArg);
        Mutable aggregateArgs = (Mutable)functionCall.getArguments().get(0);
        LogicalVariable aggregateVariable = (LogicalVariable)assign.getVariables().get(0);
        AggregateOperator aggregateOperator = this.getAggregateOperator(aggregateInfo, (Mutable<ILogicalExpression>)aggregateArgs, aggregateVariable);
        aggregateOperator.getInputs().add(nextOperatorRef);
        nextOperatorRef = new MutableObject((Object)aggregateOperator);
        SubplanOperator subplanOperator = new SubplanOperator();
        subplanOperator.getInputs().add(assign.getInputs().get(0));
        subplanOperator.setRootOp((Mutable)nextOperatorRef);
        opRef.setValue((Object)subplanOperator);
        return true;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    private AggregateOperator getAggregateOperator(IFunctionInfo aggregateFunction, Mutable<ILogicalExpression> aggregateArgs, LogicalVariable aggregateVariable) {
        ArrayList<LogicalVariable> aggregateVariables = new ArrayList<LogicalVariable>();
        aggregateVariables.add(aggregateVariable);
        ArrayList<Mutable<ILogicalExpression>> aggregateSequenceArgs = new ArrayList<Mutable<ILogicalExpression>>();
        aggregateSequenceArgs.add(aggregateArgs);
        ArrayList<MutableObject> exprs = new ArrayList<MutableObject>();
        AggregateFunctionCallExpression aggregateExp = new AggregateFunctionCallExpression(aggregateFunction, true, aggregateSequenceArgs);
        MutableObject aggregateExpRef = new MutableObject((Object)aggregateExp);
        exprs.add(aggregateExpRef);
        return new AggregateOperator(aggregateVariables, exprs);
    }

    private Mutable<ILogicalOperator> getInputOperator(Mutable<ILogicalOperator> opRef) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case SUBPLAN: {
                SubplanOperator subplan = (SubplanOperator)op;
                return this.getInputOperator((Mutable<ILogicalOperator>)((Mutable)((ILogicalPlan)subplan.getNestedPlans().get(0)).getRoots().get(0)));
            }
            case NESTEDTUPLESOURCE: {
                NestedTupleSourceOperator nts = (NestedTupleSourceOperator)op;
                return this.getInputOperator((Mutable<ILogicalOperator>)nts.getDataSourceReference());
            }
        }
        return opRef;
    }

    private UnnestOperator getUnnestOperator(LogicalVariable inputVariable, LogicalVariable unnestVariable) {
        VariableReferenceExpression inputVre = new VariableReferenceExpression(inputVariable);
        ArrayList<MutableObject> iterateArgs = new ArrayList<MutableObject>();
        iterateArgs.add(new MutableObject((Object)inputVre));
        UnnestingFunctionCallExpression unnestExp = new UnnestingFunctionCallExpression((IFunctionInfo)BuiltinOperators.ITERATE, iterateArgs);
        MutableObject unnestExpRef = new MutableObject((Object)unnestExp);
        return new UnnestOperator(unnestVariable, (Mutable)unnestExpRef);
    }
}

