/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.rewriter.rules.AbstractUsedVariablesProcessingRule;
import org.apache.vxquery.compiler.rewriter.rules.util.ExpressionToolbox;
import org.apache.vxquery.functions.Function;

public class ConsolidateUnnestsRule
extends AbstractUsedVariablesProcessingRule {
    @Override
    protected boolean processOperator(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest1 = (UnnestOperator)op;
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((Mutable)unnest1.getInputs().get(0)).getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest2 = (UnnestOperator)op2;
        if (!this.usedVariables.contains(unnest2.getVariable())) {
            ILogicalExpression logicalExpression2 = (ILogicalExpression)unnest2.getExpressionRef().getValue();
            if (logicalExpression2.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return false;
            }
            AbstractFunctionCallExpression functionCall2 = (AbstractFunctionCallExpression)logicalExpression2;
            Function functionInfo2 = (Function)functionCall2.getFunctionInfo();
            if (!functionInfo2.hasScalarEvaluatorFactory()) {
                return false;
            }
            Mutable<ILogicalExpression> unnest1Arg = ExpressionToolbox.findVariableExpression((Mutable<ILogicalExpression>)unnest1.getExpressionRef(), unnest2.getVariable());
            if (unnest1Arg == null) {
                return false;
            }
            ScalarFunctionCallExpression child = new ScalarFunctionCallExpression((IFunctionInfo)functionInfo2, functionCall2.getArguments());
            unnest1Arg.setValue((Object)child);
            unnest1.getInputs().clear();
            unnest1.getInputs().addAll(unnest2.getInputs());
        }
        return false;
    }
}

