/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public abstract class AbstractUsedVariablesProcessingRule
implements IAlgebraicRewriteRule {
    protected List<LogicalVariable> usedVariables = new ArrayList<LogicalVariable>();
    protected boolean hasRun = false;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        this.usedVariables.clear();
        boolean modified = this.rewritePreOnePass(opRef, context);
        this.hasRun = true;
        return modified;
    }

    protected boolean rewritePreOnePass(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean modified = this.processOperator(opRef, context);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opwnp = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan rootPlans : opwnp.getNestedPlans()) {
                for (Mutable inputOpRef : rootPlans.getRoots()) {
                    if (!this.rewritePreOnePass((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
                    modified = true;
                }
            }
        }
        VariableUtilities.getUsedVariables((ILogicalOperator)op, this.usedVariables);
        if (op.hasInputs()) {
            for (Mutable inputOpRef : op.getInputs()) {
                if (!this.rewritePreOnePass((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
                modified = true;
            }
        }
        return modified;
    }

    protected abstract boolean processOperator(Mutable<ILogicalOperator> var1, IOptimizationContext var2) throws AlgebricksException;
}

