/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.rewriter.rules;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.rewriter.rules.util.ExpressionToolbox;
import org.apache.vxquery.compiler.rewriter.rules.util.OperatorToolbox;
import org.apache.vxquery.context.RootStaticContextImpl;
import org.apache.vxquery.context.StaticContextImpl;
import org.apache.vxquery.types.SequenceType;

public abstract class AbstractRemoveRedundantTypeExpressionsRule
implements IAlgebraicRewriteRule {
    final StaticContextImpl dCtx = new StaticContextImpl(RootStaticContextImpl.INSTANCE);
    final int ARG_DATA = 0;
    final int ARG_TYPE = 1;
    final List<Mutable<ILogicalExpression>> functionList = new ArrayList<Mutable<ILogicalExpression>>();

    protected abstract FunctionIdentifier getSearchFunction();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean modified = false;
        List<Mutable<ILogicalExpression>> expressions = OperatorToolbox.getExpressions(opRef);
        for (Mutable<ILogicalExpression> expression : expressions) {
            if (!this.processTypeExpression(opRef, expression)) continue;
            modified = true;
        }
        return modified;
    }

    private boolean processTypeExpression(Mutable<ILogicalOperator> opRef, Mutable<ILogicalExpression> search) {
        boolean modified = false;
        this.functionList.clear();
        ExpressionToolbox.findAllFunctionExpressions(search, this.getSearchFunction(), this.functionList);
        for (Mutable<ILogicalExpression> searchM : this.functionList) {
            AbstractFunctionCallExpression searchFunction = (AbstractFunctionCallExpression)searchM.getValue();
            Mutable argFirstM = (Mutable)searchFunction.getArguments().get(0);
            SequenceType inputSequenceType = ExpressionToolbox.getOutputSequenceType(opRef, (Mutable<ILogicalExpression>)argFirstM, this.dCtx);
            SequenceType sTypeArg = null;
            if (this.hasTypeArgument()) {
                sTypeArg = ExpressionToolbox.getTypeExpressionTypeArgument(searchM, this.dCtx);
            }
            if (!this.matchesAllInstancesOf(sTypeArg, inputSequenceType)) continue;
            searchM.setValue(argFirstM.getValue());
            modified = true;
        }
        return modified;
    }

    public abstract boolean matchesAllInstancesOf(SequenceType var1, SequenceType var2);

    public boolean hasTypeArgument() {
        return true;
    }
}

