/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.algebricks.prettyprint;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import edu.uci.ics.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.algebricks.VXQueryConstantValue;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.functions.BuiltinOperators;
import org.apache.vxquery.serializer.XMLSerializer;
import org.apache.vxquery.types.SequenceType;

public class VXQueryLogicalExpressionPrettyPrintVisitor
implements ILogicalExpressionVisitor<String, Integer> {
    StaticContext ctx;
    IntegerPointable ip;
    TaggedValuePointable tvp;
    XMLSerializer serializer;
    ByteArrayOutputStream os;
    PrintStream ps;

    public VXQueryLogicalExpressionPrettyPrintVisitor(StaticContext ctx) {
        this.ctx = ctx;
        this.ip = (IntegerPointable)IntegerPointable.FACTORY.createPointable();
        this.tvp = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        this.serializer = new XMLSerializer();
        this.os = new ByteArrayOutputStream();
        this.ps = new PrintStream(this.os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String visitConstantExpression(ConstantExpression expr, Integer indent) throws AlgebricksException {
        IAlgebricksConstantValue value = expr.getValue();
        if (value instanceof VXQueryConstantValue) {
            VXQueryConstantValue vxqValue = (VXQueryConstantValue)value;
            this.tvp.set(vxqValue.getValue(), 0, vxqValue.getValue().length);
            this.serializer.printTaggedValuePointable(this.ps, this.tvp);
            try {
                String string = vxqValue.getType() + ": " + this.os.toString("UTF8");
                return string;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            finally {
                this.ps.flush();
                this.os.reset();
            }
        }
        return value.toString();
    }

    public String visitVariableReferenceExpression(VariableReferenceExpression expr, Integer indent) throws AlgebricksException {
        return expr.toString();
    }

    public String visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Integer indent) throws AlgebricksException {
        if (expr.isTwoStep()) {
            IFunctionInfo step1Agg = expr.getStepOneAggregate();
            String step1 = step1Agg != null ? step1Agg.getFunctionIdentifier().toString() : "null";
            IFunctionInfo step2Agg = expr.getStepTwoAggregate();
            String step2 = step2Agg != null ? step2Agg.getFunctionIdentifier().toString() : "null";
            StringBuilder sb = new StringBuilder();
            sb.append("function-call: [" + step1 + "|" + step2 + "], Args:");
            this.appendArguments(sb, expr.getArguments(), indent + 2);
            return sb.toString();
        }
        if (expr.getFunctionInfo() == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("function-call: [null], Args:");
            this.appendArguments(sb, expr.getArguments(), indent + 2);
            return sb.toString();
        }
        return this.appendFunction(new StringBuilder(), (AbstractFunctionCallExpression)expr, indent).toString();
    }

    public String visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Integer indent) throws AlgebricksException {
        return this.appendFunction(new StringBuilder(), (AbstractFunctionCallExpression)expr, indent).toString();
    }

    public String visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Integer indent) throws AlgebricksException {
        return this.appendFunction(new StringBuilder(), (AbstractFunctionCallExpression)expr, indent).toString();
    }

    public String visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Integer indent) throws AlgebricksException {
        return this.appendFunction(new StringBuilder(), (AbstractFunctionCallExpression)expr, indent).toString();
    }

    protected boolean identifiesTypeOperator(FunctionIdentifier fi) {
        return BuiltinOperators.PROMOTE.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.TREAT.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.CAST.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.CASTABLE.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.INSTANCE_OF.getFunctionIdentifier().equals((Object)fi);
    }

    protected boolean identifiesPathStep(FunctionIdentifier fi) {
        return BuiltinOperators.CHILD.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.ATTRIBUTE.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.ANCESTOR.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.ANCESTOR_OR_SELF.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.DESCENDANT.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.DESCENDANT_OR_SELF.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.PARENT.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.FOLLOWING.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.FOLLOWING_SIBLING.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.PRECEDING.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.PRECEDING_SIBLING.getFunctionIdentifier().equals((Object)fi) || BuiltinOperators.SELF.getFunctionIdentifier().equals((Object)fi);
    }

    protected StringBuilder appendFunction(StringBuilder sb, AbstractFunctionCallExpression expr, Integer indent) throws AlgebricksException {
        assert (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL);
        FunctionIdentifier fi = expr.getFunctionIdentifier();
        List args = expr.getArguments();
        if ((this.identifiesTypeOperator(fi) || this.identifiesPathStep(fi)) && args.size() > 1) {
            ILogicalExpression typeEx = (ILogicalExpression)((Mutable)args.get(1)).getValue();
            assert (typeEx.getExpressionTag() == LogicalExpressionTag.CONSTANT);
            SequenceType type = this.getSequenceType((ConstantExpression)typeEx);
            sb.append(fi + " <" + type + ">, Args:");
            this.appendArgument(sb, (Mutable<ILogicalExpression>)((Mutable)args.get(0)), indent + 2);
        } else {
            sb.append("function-call: " + fi + ", Args:");
            this.appendArguments(sb, args, indent + 2);
        }
        return sb;
    }

    protected StringBuilder appendArguments(StringBuilder sb, List<Mutable<ILogicalExpression>> args, Integer indent) throws AlgebricksException {
        sb.append("[\n");
        for (Mutable<ILogicalExpression> arg : args) {
            VXQueryLogicalExpressionPrettyPrintVisitor.addIndent(sb, indent + 2).append((String)((ILogicalExpression)arg.getValue()).accept((ILogicalExpressionVisitor)this, (Object)(indent + 2))).append("\n");
        }
        return VXQueryLogicalExpressionPrettyPrintVisitor.addIndent(sb, indent).append("]");
    }

    protected StringBuilder appendArgument(StringBuilder sb, Mutable<ILogicalExpression> arg, Integer indent) throws AlgebricksException {
        sb.append("[\n");
        VXQueryLogicalExpressionPrettyPrintVisitor.addIndent(sb, indent + 2).append((String)((ILogicalExpression)arg.getValue()).accept((ILogicalExpressionVisitor)this, (Object)(indent + 2))).append("\n");
        return VXQueryLogicalExpressionPrettyPrintVisitor.addIndent(sb, indent).append("]");
    }

    protected SequenceType getSequenceType(ConstantExpression cTypeEx) {
        VXQueryConstantValue typeCodeVal = (VXQueryConstantValue)cTypeEx.getValue();
        this.tvp.set(typeCodeVal.getValue(), 0, typeCodeVal.getValue().length);
        assert (this.tvp.getTag() == 29);
        this.tvp.getValue((IPointable)this.ip);
        int typeCode = this.ip.getInteger();
        SequenceType type = this.ctx.lookupSequenceType(typeCode);
        return type;
    }

    protected static final StringBuilder addIndent(StringBuilder buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append(' ');
        }
        return buffer;
    }
}

