/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.algebricks;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.ICopySerializableAggregateFunctionFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.evaluators.ConstantEvaluatorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.evaluators.TupleFieldEvaluatorFactory;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.vxquery.compiler.algebricks.VXQueryConstantValue;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.functions.Function;

public class VXQueryExpressionRuntimeProvider
implements IExpressionRuntimeProvider {
    public IScalarEvaluatorFactory createEvaluatorFactory(ILogicalExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        switch (expr.getExpressionTag()) {
            case CONSTANT: {
                IAlgebricksConstantValue constantValue = ((ConstantExpression)expr).getValue();
                if (constantValue.isFalse()) {
                    BooleanPointable p = (BooleanPointable)BooleanPointable.FACTORY.createPointable();
                    XDMConstants.setFalse((IPointable)p);
                    return new ConstantEvaluatorFactory(p.getByteArray());
                }
                if (constantValue.isNull()) {
                    VoidPointable p = (VoidPointable)VoidPointable.FACTORY.createPointable();
                    XDMConstants.setEmptySequence((IPointable)p);
                    return new ConstantEvaluatorFactory(p.getByteArray());
                }
                if (constantValue.isTrue()) {
                    BooleanPointable p = (BooleanPointable)BooleanPointable.FACTORY.createPointable();
                    XDMConstants.setTrue((IPointable)p);
                    return new ConstantEvaluatorFactory(p.getByteArray());
                }
                VXQueryConstantValue cv = (VXQueryConstantValue)((ConstantExpression)expr).getValue();
                return new ConstantEvaluatorFactory(cv.getValue());
            }
            case VARIABLE: {
                VariableReferenceExpression vrExpr = (VariableReferenceExpression)expr;
                int tupleFieldIndex = inputSchemas[0].findVariable(vrExpr.getVariableReference());
                return new TupleFieldEvaluatorFactory(tupleFieldIndex);
            }
            case FUNCTION_CALL: {
                ScalarFunctionCallExpression fcExpr = (ScalarFunctionCallExpression)expr;
                Function fn = (Function)fcExpr.getFunctionInfo();
                IScalarEvaluatorFactory[] argFactories = this.createArgumentEvaluatorFactories(env, inputSchemas, context, fcExpr.getArguments());
                try {
                    return fn.createScalarEvaluatorFactory(argFactories);
                }
                catch (SystemException e) {
                    throw new AlgebricksException((Throwable)e);
                }
            }
        }
        throw new UnsupportedOperationException("Cannot create runtime for " + expr.getExpressionTag());
    }

    private IScalarEvaluatorFactory[] createArgumentEvaluatorFactories(IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context, List<Mutable<ILogicalExpression>> args) throws AlgebricksException {
        IScalarEvaluatorFactory[] argFactories = new IScalarEvaluatorFactory[args.size()];
        for (int i = 0; i < argFactories.length; ++i) {
            Mutable<ILogicalExpression> arg = args.get(i);
            argFactories[i] = this.createEvaluatorFactory((ILogicalExpression)arg.getValue(), env, inputSchemas, context);
        }
        return argFactories;
    }

    public IAggregateEvaluatorFactory createAggregateFunctionFactory(AggregateFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        Function fn = (Function)expr.getFunctionInfo();
        IScalarEvaluatorFactory[] argFactories = this.createArgumentEvaluatorFactories(env, inputSchemas, context, expr.getArguments());
        try {
            return fn.createAggregateEvaluatorFactory(argFactories);
        }
        catch (SystemException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public ICopySerializableAggregateFunctionFactory createSerializableAggregateFunctionFactory(AggregateFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        return null;
    }

    public IRunningAggregateEvaluatorFactory createRunningAggregateFunctionFactory(StatefulFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        return null;
    }

    public IUnnestingEvaluatorFactory createUnnestingFunctionFactory(UnnestingFunctionCallExpression expr, IVariableTypeEnvironment env, IOperatorSchema[] inputSchemas, JobGenContext context) throws AlgebricksException {
        Function fn = (Function)expr.getFunctionInfo();
        IScalarEvaluatorFactory[] argFactories = this.createArgumentEvaluatorFactories(env, inputSchemas, context, expr.getArguments());
        try {
            return fn.createUnnestingEvaluatorFactory(argFactories);
        }
        catch (SystemException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }
}

