/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.compiler.algebricks;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;

public class VXQueryComparatorFactoryProvider
implements IBinaryComparatorFactoryProvider {
    public IBinaryComparatorFactory getBinaryComparatorFactory(Object type, boolean ascending) throws AlgebricksException {
        return new BinaryComparatorFactory(type, ascending);
    }

    private static class BinaryComparatorFactory
    implements IBinaryComparatorFactory {
        private static final long serialVersionUID = 1L;
        private final boolean ascending;

        public BinaryComparatorFactory(Object type, boolean ascending) {
            this.ascending = ascending;
        }

        public IBinaryComparator createBinaryComparator() {
            final TaggedValuePointable tvp1 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
            final TaggedValuePointable tvp2 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
            return new IBinaryComparator(){

                public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                    tvp1.set(b1, s1, l1);
                    tvp2.set(b2, s2, l2);
                    for (int i = 0; i < l1 && i < l2; ++i) {
                        if (b1[s1 + i] == b2[s2 + i]) continue;
                        return b1[s1 + i] - b2[s2 + i];
                    }
                    return l1 - l2;
                }
            };
        }
    }
}

