/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.collations;

import java.util.Comparator;
import org.apache.vxquery.collations.Collation;

public class CodepointCollation
implements Collation {
    public static final String URI = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private static final Comparator<CharSequence> COMPARATOR = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l1 = o1.length();
            int l2 = o2.length();
            int i1 = 0;
            int i2 = 0;
            while (i1 < l1) {
                int cp2;
                if (i2 >= l2) {
                    return 1;
                }
                int cp1 = Character.codePointAt(o1, i1);
                if (cp1 < (cp2 = Character.codePointAt(o2, i2))) {
                    return -1;
                }
                if (cp1 > cp2) {
                    return 1;
                }
                i1 += Character.charCount(cp1);
                i2 += Character.charCount(cp2);
            }
            return i2 >= 0 ? 0 : -1;
        }
    };
    public static final Collation INSTANCE = new CodepointCollation();

    private CodepointCollation() {
    }

    @Override
    public boolean contains(CharSequence cs1, CharSequence cs2) {
        return cs1.toString().contains(cs2);
    }

    @Override
    public boolean endsWith(CharSequence cs1, CharSequence cs2) {
        return cs1.toString().endsWith(cs2.toString());
    }

    @Override
    public Comparator<CharSequence> getComparator() {
        return COMPARATOR;
    }

    @Override
    public boolean startsWith(CharSequence cs1, CharSequence cs2) {
        return cs1.toString().startsWith(cs2.toString());
    }

    @Override
    public CharSequence substringAfter(CharSequence cs1, CharSequence cs2) {
        String s2;
        String s1 = cs1.toString();
        int idx = s1.indexOf(s2 = cs2.toString());
        return idx < 0 ? "" : s1.substring(idx + s2.length());
    }

    @Override
    public CharSequence substringBefore(CharSequence cs1, CharSequence cs2) {
        String s2;
        String s1 = cs1.toString();
        int idx = s1.indexOf(s2 = cs2.toString());
        return idx < 0 ? "" : s1.substring(0, idx);
    }

    @Override
    public boolean supportsStringMatching() {
        return true;
    }
}

