/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.impls;

import edu.uci.ics.hyracks.storage.am.common.api.ISplitKey;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import java.nio.ByteBuffer;

public class BTreeSplitKey
implements ISplitKey {
    public final ITreeIndexTupleReference tuple;
    public byte[] data = null;
    public ByteBuffer buf = null;
    public int keySize = 0;

    public BTreeSplitKey(ITreeIndexTupleReference tuple) {
        this.tuple = tuple;
    }

    public void initData(int keySize) {
        this.keySize = keySize;
        if (this.data != null) {
            if (this.data.length < keySize + 8) {
                this.data = new byte[keySize + 8];
                this.buf = ByteBuffer.wrap(this.data);
            }
        } else {
            this.data = new byte[keySize + 8];
            this.buf = ByteBuffer.wrap(this.data);
        }
        this.tuple.resetByTupleOffset(this.buf, 0);
    }

    public void reset() {
        this.data = null;
        this.buf = null;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    public ITreeIndexTupleReference getTuple() {
        return this.tuple;
    }

    public int getLeftPage() {
        return this.buf.getInt(this.keySize);
    }

    public int getRightPage() {
        return this.buf.getInt(this.keySize + 4);
    }

    public void setLeftPage(int leftPage) {
        this.buf.putInt(this.keySize, leftPage);
    }

    public void setRightPage(int rightPage) {
        this.buf.putInt(this.keySize + 4, rightPage);
    }

    public void setPages(int leftPage, int rightPage) {
        this.buf.putInt(this.keySize, leftPage);
        this.buf.putInt(this.keySize + 4, rightPage);
    }

    public BTreeSplitKey duplicate(ITreeIndexTupleReference copyTuple) {
        BTreeSplitKey copy = new BTreeSplitKey(copyTuple);
        copy.data = (byte[])this.data.clone();
        copy.buf = ByteBuffer.wrap(copy.data);
        copy.tuple.setFieldCount(this.tuple.getFieldCount());
        copy.tuple.resetByTupleOffset(copy.buf, 0);
        return copy;
    }
}

