/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.impls;

import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.common.util.TupleUtils;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeInteriorFrame;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import edu.uci.ics.hyracks.storage.am.btree.api.ITupleAcceptor;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeSplitKey;
import edu.uci.ics.hyracks.storage.am.btree.impls.RangePredicate;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexOperationContext;
import edu.uci.ics.hyracks.storage.am.common.api.IModificationOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.IndexOperation;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.IntArrayList;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.LongArrayList;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import java.util.ArrayDeque;
import java.util.Deque;

public class BTreeOpContext
implements IIndexOperationContext {
    private final int INIT_ARRAYLIST_SIZE = 6;
    public IIndexAccessor accessor;
    public MultiComparator cmp;
    public ITreeIndexFrameFactory leafFrameFactory;
    public ITreeIndexFrameFactory interiorFrameFactory;
    public IBTreeLeafFrame leafFrame;
    public IBTreeInteriorFrame interiorFrame;
    public ITreeIndexMetaDataFrame metaFrame;
    public IndexOperation op;
    public ITreeIndexCursor cursor;
    public BTreeCursorInitialState cursorInitialState;
    public RangePredicate pred;
    public BTreeSplitKey splitKey;
    public LongArrayList pageLsns;
    public IntArrayList smPages;
    public IntArrayList freePages;
    public int opRestarts = 0;
    public boolean exceptionHandled;
    public IModificationOperationCallback modificationCallback;
    public ISearchOperationCallback searchCallback;
    public ITupleAcceptor acceptor;
    public int smoCount;
    public final Deque<PageValidationInfo> validationInfos;
    public final ITreeIndexTupleReference interiorFrameTuple;
    public final ITreeIndexTupleReference leafFrameTuple;

    public BTreeOpContext(IIndexAccessor accessor, ITreeIndexFrameFactory leafFrameFactory, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexMetaDataFrame metaFrame, IBinaryComparatorFactory[] cmpFactories, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        this.accessor = accessor;
        this.cmp = cmpFactories[0] != null ? MultiComparator.create((IBinaryComparatorFactory[])cmpFactories) : null;
        this.leafFrameFactory = leafFrameFactory;
        this.leafFrame = (IBTreeLeafFrame)leafFrameFactory.createFrame();
        if (this.leafFrame != null && this.cmp != null) {
            this.leafFrame.setMultiComparator(this.cmp);
        }
        this.interiorFrameFactory = interiorFrameFactory;
        this.interiorFrame = (IBTreeInteriorFrame)interiorFrameFactory.createFrame();
        if (this.interiorFrame != null && this.cmp != null) {
            this.interiorFrame.setMultiComparator(this.cmp);
        }
        this.metaFrame = metaFrame;
        this.pageLsns = new LongArrayList(6, 6);
        this.smoCount = 0;
        this.modificationCallback = modificationCallback;
        this.searchCallback = searchCallback;
        this.validationInfos = new ArrayDeque<PageValidationInfo>(6);
        this.interiorFrameTuple = this.interiorFrame.createTupleReference();
        this.leafFrameTuple = this.leafFrame.createTupleReference();
    }

    public void reset() {
        if (this.pageLsns != null) {
            this.pageLsns.clear();
        }
        if (this.freePages != null) {
            this.freePages.clear();
        }
        if (this.smPages != null) {
            this.smPages.clear();
        }
        this.opRestarts = 0;
        this.smoCount = 0;
        this.exceptionHandled = false;
    }

    public void setOperation(IndexOperation newOp) {
        if (newOp == IndexOperation.SEARCH || newOp == IndexOperation.DISKORDERSCAN) {
            if (this.cursorInitialState == null) {
                this.cursorInitialState = new BTreeCursorInitialState(null, this.searchCallback, this.accessor);
            }
        } else {
            if (this.smPages == null) {
                this.smPages = new IntArrayList(6, 6);
            }
            if (this.freePages == null) {
                this.freePages = new IntArrayList(6, 6);
            }
            if (this.pred == null) {
                this.pred = new RangePredicate(null, null, true, true, null, null);
            }
            if (this.splitKey == null) {
                this.splitKey = new BTreeSplitKey(this.leafFrame.getTupleWriter().createTupleReference());
            }
        }
        this.op = newOp;
        this.smoCount = 0;
        this.exceptionHandled = false;
    }

    public IBTreeLeafFrame createLeafFrame() {
        return (IBTreeLeafFrame)this.leafFrameFactory.createFrame();
    }

    public IBTreeInteriorFrame createInteriorFrame() {
        return (IBTreeInteriorFrame)this.interiorFrameFactory.createFrame();
    }

    public PageValidationInfo createPageValidationInfo(PageValidationInfo parent) throws HyracksDataException {
        return new PageValidationInfo(parent);
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public class PageValidationInfo {
        public final int numKeyFields;
        public final ArrayTupleBuilder lowRangeBuilder;
        public final ArrayTupleBuilder highRangeBuilder;
        public final ArrayTupleReference lowRangeTuple;
        public final ArrayTupleReference highRangeTuple;
        public boolean isLowRangeNull;
        public boolean isHighRangeNull;

        public PageValidationInfo() {
            this.numKeyFields = BTreeOpContext.this.cmp.getKeyFieldCount();
            this.lowRangeBuilder = new ArrayTupleBuilder(this.numKeyFields);
            this.highRangeBuilder = new ArrayTupleBuilder(this.numKeyFields);
            this.lowRangeTuple = new ArrayTupleReference();
            this.highRangeTuple = new ArrayTupleReference();
            this.isLowRangeNull = true;
            this.isHighRangeNull = true;
        }

        public PageValidationInfo(PageValidationInfo copy) throws HyracksDataException {
            this();
            if (copy != null) {
                this.propagateLowRangeKey(copy);
                this.propagateHighRangeKey(copy);
            }
        }

        public void propagateLowRangeKey(PageValidationInfo toPropagate) throws HyracksDataException {
            this.isLowRangeNull = toPropagate.isLowRangeNull;
            if (!this.isLowRangeNull) {
                this.adjustRangeKey(this.lowRangeBuilder, this.lowRangeTuple, (ITupleReference)toPropagate.lowRangeTuple);
            }
        }

        public void propagateHighRangeKey(PageValidationInfo toPropagate) throws HyracksDataException {
            this.isHighRangeNull = toPropagate.isHighRangeNull;
            if (!this.isHighRangeNull) {
                this.adjustRangeKey(this.highRangeBuilder, this.highRangeTuple, (ITupleReference)toPropagate.highRangeTuple);
            }
        }

        public void adjustLowRangeKey(ITupleReference newLowRangeKey) throws HyracksDataException {
            boolean bl = this.isLowRangeNull = newLowRangeKey == null;
            if (!this.isLowRangeNull) {
                this.adjustRangeKey(this.lowRangeBuilder, this.lowRangeTuple, newLowRangeKey);
            }
        }

        public void adjustHighRangeKey(ITupleReference newHighRangeKey) throws HyracksDataException {
            boolean bl = this.isHighRangeNull = newHighRangeKey == null;
            if (!this.isHighRangeNull) {
                this.adjustRangeKey(this.highRangeBuilder, this.highRangeTuple, newHighRangeKey);
            }
        }

        private void adjustRangeKey(ArrayTupleBuilder builder, ArrayTupleReference tuple, ITupleReference newRangeKey) throws HyracksDataException {
            TupleUtils.copyTuple((ArrayTupleBuilder)builder, (ITupleReference)newRangeKey, (int)this.numKeyFields);
            tuple.reset(builder.getFieldEndOffsets(), builder.getByteArray());
        }
    }
}

