/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.impls;

import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.util.TupleUtils;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeInteriorFrame;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import edu.uci.ics.hyracks.storage.am.btree.api.ITupleAcceptor;
import edu.uci.ics.hyracks.storage.am.btree.exceptions.BTreeException;
import edu.uci.ics.hyracks.storage.am.btree.exceptions.BTreeNotUpdateableException;
import edu.uci.ics.hyracks.storage.am.btree.frames.BTreeNSMInteriorFrame;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeCountingSearchCursor;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeOpContext;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeSplitKey;
import edu.uci.ics.hyracks.storage.am.btree.impls.RangePredicate;
import edu.uci.ics.hyracks.storage.am.btree.impls.UnconditionalTupleAcceptor;
import edu.uci.ics.hyracks.storage.am.common.api.ICursorInitialState;
import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexBulkLoader;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.IModificationOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchPredicate;
import edu.uci.ics.hyracks.storage.am.common.api.ISplitKey;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.IndexException;
import edu.uci.ics.hyracks.storage.am.common.api.TreeIndexException;
import edu.uci.ics.hyracks.storage.am.common.api.UnsortedInputException;
import edu.uci.ics.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import edu.uci.ics.hyracks.storage.am.common.exceptions.TreeIndexNonExistentKeyException;
import edu.uci.ics.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import edu.uci.ics.hyracks.storage.am.common.impls.AbstractTreeIndex;
import edu.uci.ics.hyracks.storage.am.common.impls.NoOpOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.impls.NodeFrontier;
import edu.uci.ics.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.IndexOperation;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;
import edu.uci.ics.hyracks.storage.common.file.IFileMapProvider;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BTree
extends AbstractTreeIndex {
    public static final float DEFAULT_FILL_FACTOR = 0.7f;
    private static final long RESTART_OP = Long.MIN_VALUE;
    private static final long FULL_RESTART_OP = -9223372036854775807L;
    private static final int MAX_RESTARTS = 10;
    private final AtomicInteger smoCounter;
    private final ReadWriteLock treeLatch = new ReentrantReadWriteLock(true);
    private final int maxTupleSize;

    public BTree(IBufferCache bufferCache, IFileMapProvider fileMapProvider, IFreePageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        super(bufferCache, fileMapProvider, freePageManager, interiorFrameFactory, leafFrameFactory, cmpFactories, fieldCount, file);
        this.smoCounter = new AtomicInteger();
        ITreeIndexFrame leafFrame = leafFrameFactory.createFrame();
        ITreeIndexFrame interiorFrame = interiorFrameFactory.createFrame();
        this.maxTupleSize = Math.min(leafFrame.getMaxTupleSize(bufferCache.getPageSize()), interiorFrame.getMaxTupleSize(bufferCache.getPageSize()));
    }

    private void diskOrderScan(ITreeIndexCursor icursor, BTreeOpContext ctx) throws HyracksDataException {
        TreeIndexDiskOrderScanCursor cursor = (TreeIndexDiskOrderScanCursor)icursor;
        ctx.reset();
        RangePredicate diskOrderScanPred = new RangePredicate(null, null, true, true, ctx.cmp, ctx.cmp);
        int currentPageId = 1;
        int maxPageId = this.freePageManager.getMaxPage(ctx.metaFrame);
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)currentPageId), false);
        page.acquireReadLatch();
        try {
            cursor.setBufferCache(this.bufferCache);
            cursor.setFileId(this.fileId);
            cursor.setCurrentPageId(currentPageId);
            cursor.setMaxPageId(maxPageId);
            ctx.cursorInitialState.setPage(page);
            ctx.cursorInitialState.setSearchOperationCallback(ctx.searchCallback);
            ctx.cursorInitialState.setOriginialKeyComparator(ctx.cmp);
            cursor.open((ICursorInitialState)ctx.cursorInitialState, (ISearchPredicate)diskOrderScanPred);
        }
        catch (Exception e) {
            page.releaseReadLatch();
            this.bufferCache.unpin(page);
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void validate() throws HyracksDataException {
        BTreeAccessor accessor = (BTreeAccessor)this.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        BTreeOpContext.PageValidationInfo pvi = accessor.ctx.createPageValidationInfo(null);
        ((BTreeAccessor)accessor).ctx.validationInfos.addFirst(pvi);
        this.validate(accessor.ctx, 1);
    }

    private void validate(BTreeOpContext ctx, int pageId) throws HyracksDataException {
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
        ctx.interiorFrame.setPage(page);
        BTreeOpContext.PageValidationInfo currentPvi = ctx.validationInfos.peekFirst();
        boolean isLeaf = ctx.interiorFrame.isLeaf();
        if (isLeaf) {
            ctx.leafFrame.setPage(page);
            ctx.leafFrame.validate(currentPvi);
        } else {
            BTreeOpContext.PageValidationInfo nextPvi = ctx.createPageValidationInfo(currentPvi);
            ArrayList<Integer> children = ((BTreeNSMInteriorFrame)ctx.interiorFrame).getChildren(ctx.cmp);
            ctx.interiorFrame.validate(currentPvi);
            for (int i = 0; i < children.size(); ++i) {
                ctx.interiorFrame.setPage(page);
                if (children.size() == 1) {
                    nextPvi.propagateLowRangeKey(currentPvi);
                    nextPvi.propagateHighRangeKey(currentPvi);
                } else if (i == 0) {
                    nextPvi.propagateLowRangeKey(currentPvi);
                    ctx.interiorFrameTuple.resetByTupleIndex((ITreeIndexFrame)ctx.interiorFrame, i);
                    nextPvi.adjustHighRangeKey((ITupleReference)ctx.interiorFrameTuple);
                } else if (i == children.size() - 1) {
                    nextPvi.propagateHighRangeKey(currentPvi);
                    ctx.interiorFrameTuple.resetByTupleIndex((ITreeIndexFrame)ctx.interiorFrame, i - 1);
                    nextPvi.adjustLowRangeKey((ITupleReference)ctx.interiorFrameTuple);
                } else {
                    ctx.interiorFrameTuple.resetByTupleIndex((ITreeIndexFrame)ctx.interiorFrame, i - 1);
                    nextPvi.adjustLowRangeKey((ITupleReference)ctx.interiorFrameTuple);
                    ctx.interiorFrameTuple.resetByTupleIndex((ITreeIndexFrame)ctx.interiorFrame, i);
                    nextPvi.adjustHighRangeKey((ITupleReference)ctx.interiorFrameTuple);
                }
                ctx.validationInfos.addFirst(nextPvi);
                this.validate(ctx, (Integer)children.get(i));
            }
        }
        this.bufferCache.unpin(page);
        ctx.validationInfos.removeFirst();
    }

    private void search(ITreeIndexCursor cursor, ISearchPredicate searchPred, BTreeOpContext ctx) throws TreeIndexException, HyracksDataException {
        ctx.reset();
        ctx.pred = (RangePredicate)searchPred;
        ctx.cursor = cursor;
        if (ctx.pred.getLowKeyComparator() == null) {
            ctx.pred.setLowKeyComparator(ctx.cmp);
        }
        if (ctx.pred.getHighKeyComparator() == null) {
            ctx.pred.setHighKeyComparator(ctx.cmp);
        }
        boolean repeatOp = true;
        while (repeatOp && ctx.opRestarts < 10) {
            this.performOp(1, null, true, ctx);
            if (!ctx.pageLsns.isEmpty() && ctx.pageLsns.getLast() == Long.MIN_VALUE) {
                ctx.pageLsns.removeLast();
                continue;
            }
            repeatOp = false;
        }
        cursor.setBufferCache(this.bufferCache);
        cursor.setFileId(this.fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetSmPages(BTreeOpContext ctx) throws HyracksDataException {
        ICachedPage originalPage = ctx.interiorFrame.getPage();
        for (int i = 0; i < ctx.smPages.size(); ++i) {
            int pageId = ctx.smPages.get(i);
            ICachedPage smPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
            smPage.acquireWriteLatch();
            try {
                ctx.interiorFrame.setPage(smPage);
                ctx.interiorFrame.setSmFlag(false);
                continue;
            }
            finally {
                smPage.releaseWriteLatch(true);
                this.bufferCache.unpin(smPage);
            }
        }
        if (ctx.smPages.size() > 0) {
            if (ctx.smoCount == Integer.MAX_VALUE) {
                this.smoCounter.set(0);
            } else {
                this.smoCounter.incrementAndGet();
            }
            this.treeLatch.writeLock().unlock();
            ctx.smPages.clear();
        }
        ctx.interiorFrame.setPage(originalPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewRoot(BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        ICachedPage leftNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)ctx.splitKey.getLeftPage()), false);
        leftNode.acquireWriteLatch();
        try {
            int newLeftId = this.freePageManager.getFreePage(ctx.metaFrame);
            ICachedPage newLeftNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)newLeftId), true);
            newLeftNode.acquireWriteLatch();
            try {
                System.arraycopy(leftNode.getBuffer().array(), 0, newLeftNode.getBuffer().array(), 0, newLeftNode.getBuffer().capacity());
                ctx.interiorFrame.setPage(newLeftNode);
                ctx.interiorFrame.setSmFlag(false);
                long leftNodeLSN = ctx.interiorFrame.getPageLsn();
                ctx.interiorFrame.setPage(leftNode);
                ctx.interiorFrame.initBuffer((byte)(ctx.interiorFrame.getLevel() + 1));
                ctx.interiorFrame.setPageLsn(leftNodeLSN);
                ctx.interiorFrame.setSmFlag(true);
                ctx.splitKey.setLeftPage(newLeftId);
                int targetTupleIndex = ctx.interiorFrame.findInsertTupleIndex((ITupleReference)ctx.splitKey.getTuple());
                ctx.interiorFrame.insert((ITupleReference)ctx.splitKey.getTuple(), targetTupleIndex);
            }
            finally {
                newLeftNode.releaseWriteLatch(true);
                this.bufferCache.unpin(newLeftNode);
            }
        }
        finally {
            leftNode.releaseWriteLatch(true);
            this.bufferCache.unpin(leftNode);
        }
    }

    private void insertUpdateOrDelete(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        ctx.reset();
        ctx.pred.setLowKeyComparator(ctx.cmp);
        ctx.pred.setHighKeyComparator(ctx.cmp);
        ctx.pred.setLowKey(tuple, true);
        ctx.pred.setHighKey(tuple, true);
        ctx.splitKey.reset();
        ctx.splitKey.getTuple().setFieldCount(ctx.cmp.getKeyFieldCount());
        boolean repeatOp = true;
        while (repeatOp && ctx.opRestarts < 10) {
            ctx.smoCount = this.smoCounter.get();
            this.performOp(1, null, true, ctx);
            if (!ctx.pageLsns.isEmpty()) {
                if (ctx.pageLsns.getLast() == -9223372036854775807L) {
                    ctx.pageLsns.clear();
                    continue;
                }
                if (ctx.pageLsns.getLast() == Long.MIN_VALUE) {
                    ctx.pageLsns.removeLast();
                    continue;
                }
            }
            if (ctx.splitKey.getBuffer() != null) {
                this.createNewRoot(ctx);
            }
            this.unsetSmPages(ctx);
            repeatOp = false;
        }
        if (ctx.opRestarts >= 10) {
            throw new BTreeException("Operation exceeded the maximum number of restarts");
        }
    }

    private void insert(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        int tupleSize = Math.max(ctx.leafFrame.getBytesRequriedToWriteTuple(tuple), ctx.interiorFrame.getBytesRequriedToWriteTuple(tuple));
        if (tupleSize > this.maxTupleSize) {
            throw new TreeIndexException("Space required for record (" + tupleSize + ") larger than maximum acceptable size (" + this.maxTupleSize + ")");
        }
        ctx.modificationCallback.before(tuple);
        this.insertUpdateOrDelete(tuple, ctx);
    }

    private void upsert(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        int tupleSize = Math.max(ctx.leafFrame.getBytesRequriedToWriteTuple(tuple), ctx.interiorFrame.getBytesRequriedToWriteTuple(tuple));
        if (tupleSize > this.maxTupleSize) {
            throw new TreeIndexException("Space required for record (" + tupleSize + ") larger than maximum acceptable size (" + this.maxTupleSize + ")");
        }
        ctx.modificationCallback.before(tuple);
        this.insertUpdateOrDelete(tuple, ctx);
    }

    private void update(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        if (this.fieldCount == ctx.cmp.getKeyFieldCount()) {
            throw new BTreeNotUpdateableException("Cannot perform updates when the entire tuple forms the key.");
        }
        int tupleSize = Math.max(ctx.leafFrame.getBytesRequriedToWriteTuple(tuple), ctx.interiorFrame.getBytesRequriedToWriteTuple(tuple));
        if (tupleSize > this.maxTupleSize) {
            throw new TreeIndexException("Space required for record (" + tupleSize + ") larger than maximum acceptable size (" + this.maxTupleSize + ")");
        }
        ctx.modificationCallback.before(tuple);
        this.insertUpdateOrDelete(tuple, ctx);
    }

    private void delete(ITupleReference tuple, BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        ctx.modificationCallback.before(tuple);
        this.insertUpdateOrDelete(tuple, ctx);
    }

    private boolean insertLeaf(ITupleReference tuple, int targetTupleIndex, int pageId, BTreeOpContext ctx) throws Exception {
        boolean restartOp = false;
        FrameOpSpaceStatus spaceStatus = ctx.leafFrame.hasSpaceInsert(tuple);
        switch (spaceStatus) {
            case SUFFICIENT_CONTIGUOUS_SPACE: {
                ctx.modificationCallback.found(null, tuple);
                ctx.leafFrame.insert(tuple, targetTupleIndex);
                ctx.splitKey.reset();
                break;
            }
            case SUFFICIENT_SPACE: {
                boolean slotsChanged = ctx.leafFrame.compact();
                if (slotsChanged) {
                    targetTupleIndex = ctx.leafFrame.findInsertTupleIndex(tuple);
                }
                ctx.modificationCallback.found(null, tuple);
                ctx.leafFrame.insert(tuple, targetTupleIndex);
                ctx.splitKey.reset();
                break;
            }
            case INSUFFICIENT_SPACE: {
                boolean reCompressed = ctx.leafFrame.compress();
                if (reCompressed) {
                    targetTupleIndex = ctx.leafFrame.findInsertTupleIndex(tuple);
                    spaceStatus = ctx.leafFrame.hasSpaceInsert(tuple);
                }
                if (spaceStatus == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE) {
                    ctx.modificationCallback.found(null, tuple);
                    ctx.leafFrame.insert(tuple, targetTupleIndex);
                    ctx.splitKey.reset();
                    break;
                }
                restartOp = this.performLeafSplit(pageId, tuple, ctx, -1);
                break;
            }
        }
        return restartOp;
    }

    private boolean performLeafSplit(int pageId, ITupleReference tuple, BTreeOpContext ctx, int updateTupleIndex) throws Exception {
        if (!this.treeLatch.writeLock().tryLock()) {
            return true;
        }
        int tempSmoCount = this.smoCounter.get();
        if (tempSmoCount != ctx.smoCount) {
            this.treeLatch.writeLock().unlock();
            return true;
        }
        int rightPageId = this.freePageManager.getFreePage(ctx.metaFrame);
        ICachedPage rightNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)rightPageId), true);
        rightNode.acquireWriteLatch();
        try {
            IBTreeLeafFrame rightFrame = ctx.createLeafFrame();
            rightFrame.setPage(rightNode);
            rightFrame.initBuffer((byte)0);
            rightFrame.setMultiComparator(ctx.cmp);
            if (updateTupleIndex != -1) {
                ITupleReference beforeTuple = ctx.leafFrame.getMatchingKeyTuple(tuple, updateTupleIndex);
                ctx.modificationCallback.found(beforeTuple, tuple);
                ctx.leafFrame.delete(tuple, updateTupleIndex);
            } else {
                ctx.modificationCallback.found(null, tuple);
            }
            ctx.leafFrame.split(rightFrame, tuple, ctx.splitKey);
            ctx.smPages.add(pageId);
            ctx.smPages.add(rightPageId);
            ctx.leafFrame.setSmFlag(true);
            rightFrame.setSmFlag(true);
            rightFrame.setNextLeaf(ctx.leafFrame.getNextLeaf());
            ctx.leafFrame.setNextLeaf(rightPageId);
            rightFrame.setPageLsn(rightFrame.getPageLsn() + 1L);
            ctx.leafFrame.setPageLsn(ctx.leafFrame.getPageLsn() + 1L);
            ctx.splitKey.setPages(pageId, rightPageId);
        }
        catch (Exception e) {
            this.treeLatch.writeLock().unlock();
            throw e;
        }
        finally {
            rightNode.releaseWriteLatch(true);
            this.bufferCache.unpin(rightNode);
        }
        return false;
    }

    private boolean updateLeaf(ITupleReference tuple, int oldTupleIndex, int pageId, BTreeOpContext ctx) throws Exception {
        FrameOpSpaceStatus spaceStatus = ctx.leafFrame.hasSpaceUpdate(tuple, oldTupleIndex);
        ITupleReference beforeTuple = ctx.leafFrame.getMatchingKeyTuple(tuple, oldTupleIndex);
        boolean restartOp = false;
        switch (spaceStatus) {
            case SUFFICIENT_INPLACE_SPACE: {
                ctx.modificationCallback.found(beforeTuple, tuple);
                ctx.leafFrame.update(tuple, oldTupleIndex, true);
                ctx.splitKey.reset();
                break;
            }
            case SUFFICIENT_CONTIGUOUS_SPACE: {
                ctx.modificationCallback.found(beforeTuple, tuple);
                ctx.leafFrame.update(tuple, oldTupleIndex, false);
                ctx.splitKey.reset();
                break;
            }
            case SUFFICIENT_SPACE: {
                ctx.modificationCallback.found(beforeTuple, tuple);
                ctx.leafFrame.delete(tuple, oldTupleIndex);
                ctx.leafFrame.compact();
                int targetTupleIndex = ctx.leafFrame.findInsertTupleIndex(tuple);
                ctx.leafFrame.insert(tuple, targetTupleIndex);
                ctx.splitKey.reset();
                break;
            }
            case INSUFFICIENT_SPACE: {
                restartOp = this.performLeafSplit(pageId, tuple, ctx, oldTupleIndex);
            }
        }
        return restartOp;
    }

    private boolean upsertLeaf(ITupleReference tuple, int targetTupleIndex, int pageId, BTreeOpContext ctx) throws Exception {
        boolean restartOp = false;
        ITupleReference beforeTuple = ctx.leafFrame.getMatchingKeyTuple(tuple, targetTupleIndex);
        if (ctx.acceptor.accept(beforeTuple)) {
            restartOp = beforeTuple == null ? this.insertLeaf(tuple, targetTupleIndex, pageId, ctx) : this.updateLeaf(tuple, targetTupleIndex, pageId, ctx);
        } else {
            targetTupleIndex = ctx.leafFrame.findInsertTupleIndex(tuple);
            restartOp = this.insertLeaf(tuple, targetTupleIndex, pageId, ctx);
        }
        return restartOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInterior(ICachedPage node, int pageId, ITupleReference tuple, BTreeOpContext ctx) throws Exception {
        ctx.interiorFrame.setPage(node);
        int targetTupleIndex = ctx.interiorFrame.findInsertTupleIndex(tuple);
        FrameOpSpaceStatus spaceStatus = ctx.interiorFrame.hasSpaceInsert(tuple);
        switch (spaceStatus) {
            case INSUFFICIENT_SPACE: {
                int rightPageId = this.freePageManager.getFreePage(ctx.metaFrame);
                ICachedPage rightNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)rightPageId), true);
                rightNode.acquireWriteLatch();
                try {
                    IBTreeInteriorFrame rightFrame = ctx.createInteriorFrame();
                    rightFrame.setPage(rightNode);
                    rightFrame.initBuffer(ctx.interiorFrame.getLevel());
                    rightFrame.setMultiComparator(ctx.cmp);
                    ctx.interiorFrame.split(rightFrame, (ITupleReference)ctx.splitKey.getTuple(), ctx.splitKey);
                    ctx.smPages.add(pageId);
                    ctx.smPages.add(rightPageId);
                    ctx.interiorFrame.setSmFlag(true);
                    rightFrame.setSmFlag(true);
                    rightFrame.setPageLsn(rightFrame.getPageLsn() + 1L);
                    ctx.interiorFrame.setPageLsn(ctx.interiorFrame.getPageLsn() + 1L);
                    ctx.splitKey.setPages(pageId, rightPageId);
                    break;
                }
                finally {
                    rightNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(rightNode);
                }
            }
            case SUFFICIENT_CONTIGUOUS_SPACE: {
                ctx.interiorFrame.insert(tuple, targetTupleIndex);
                ctx.splitKey.reset();
                break;
            }
            case SUFFICIENT_SPACE: {
                boolean slotsChanged = ctx.interiorFrame.compact();
                if (slotsChanged) {
                    targetTupleIndex = ctx.interiorFrame.findInsertTupleIndex(tuple);
                }
                ctx.interiorFrame.insert(tuple, targetTupleIndex);
                ctx.splitKey.reset();
                break;
            }
        }
    }

    private boolean deleteLeaf(ICachedPage node, int pageId, ITupleReference tuple, BTreeOpContext ctx) throws Exception {
        if (ctx.leafFrame.getTupleCount() == 0) {
            throw new TreeIndexNonExistentKeyException("Trying to delete a tuple with a nonexistent key in leaf node.");
        }
        int tupleIndex = ctx.leafFrame.findDeleteTupleIndex(tuple);
        ITupleReference beforeTuple = ctx.leafFrame.getMatchingKeyTuple(tuple, tupleIndex);
        ctx.modificationCallback.found(beforeTuple, tuple);
        ctx.leafFrame.delete(tuple, tupleIndex);
        return false;
    }

    private final boolean acquireLatch(ICachedPage node, BTreeOpContext ctx, boolean isLeaf) {
        if (!isLeaf || ctx.op == IndexOperation.SEARCH && !ctx.cursor.exclusiveLatchNodes()) {
            node.acquireReadLatch();
            return true;
        }
        node.acquireWriteLatch();
        return false;
    }

    private ICachedPage isConsistent(int pageId, BTreeOpContext ctx) throws Exception {
        boolean isConsistent;
        ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
        node.acquireReadLatch();
        ctx.interiorFrame.setPage(node);
        boolean bl = isConsistent = ctx.pageLsns.getLast() == ctx.interiorFrame.getPageLsn();
        if (!isConsistent) {
            node.releaseReadLatch();
            this.bufferCache.unpin(node);
            return null;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOp(int pageId, ICachedPage parent, boolean parentIsReadLatched, BTreeOpContext ctx) throws HyracksDataException, TreeIndexException {
        block37: {
            ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
            ctx.interiorFrame.setPage(node);
            boolean unsafeIsLeaf = ctx.interiorFrame.isLeaf();
            boolean isReadLatched = this.acquireLatch(node, ctx, unsafeIsLeaf);
            boolean smFlag = ctx.interiorFrame.getSmFlag();
            boolean isLeaf = ctx.interiorFrame.isLeaf();
            ctx.pageLsns.add(ctx.interiorFrame.getPageLsn());
            try {
                if (parent != null) {
                    if (parentIsReadLatched) {
                        parent.releaseReadLatch();
                    } else {
                        parent.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(parent);
                }
                if (!isLeaf || smFlag) {
                    if (!smFlag) {
                        boolean repeatOp = true;
                        while (repeatOp && ctx.opRestarts < 10) {
                            int childPageId = ctx.interiorFrame.getChildPageId(ctx.pred);
                            this.performOp(childPageId, node, isReadLatched, ctx);
                            if (!ctx.pageLsns.isEmpty()) {
                                if (ctx.pageLsns.getLast() == -9223372036854775807L) break block37;
                                if (ctx.pageLsns.getLast() == Long.MIN_VALUE) {
                                    ctx.pageLsns.removeLast();
                                    node = this.isConsistent(pageId, ctx);
                                    if (node != null) {
                                        isReadLatched = true;
                                        continue;
                                    }
                                    ctx.pageLsns.removeLast();
                                    ctx.pageLsns.add(Long.MIN_VALUE);
                                    break block37;
                                }
                            }
                            switch (ctx.op) {
                                case INSERT: 
                                case UPSERT: 
                                case UPDATE: {
                                    if (ctx.splitKey.getBuffer() != null) {
                                        ICachedPage interiorNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                                        interiorNode.acquireWriteLatch();
                                        try {
                                            this.insertInterior(interiorNode, pageId, (ITupleReference)ctx.splitKey.getTuple(), ctx);
                                            break;
                                        }
                                        finally {
                                            interiorNode.releaseWriteLatch(true);
                                            this.bufferCache.unpin(interiorNode);
                                        }
                                    }
                                    this.unsetSmPages(ctx);
                                    break;
                                }
                                case DELETE: {
                                    if (ctx.splitKey.getBuffer() == null) break;
                                    throw new BTreeException("Split key was propagated during delete. Delete allows empty leaf pages.");
                                }
                            }
                            repeatOp = false;
                        }
                        break block37;
                    }
                    ++ctx.opRestarts;
                    if (isReadLatched) {
                        node.releaseReadLatch();
                    } else {
                        node.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(node);
                    this.treeLatch.readLock().lock();
                    this.treeLatch.readLock().unlock();
                    ctx.pageLsns.removeLast();
                    ctx.pageLsns.add(Long.MIN_VALUE);
                    break block37;
                }
                boolean restartOp = false;
                ctx.leafFrame.setPage(node);
                switch (ctx.op) {
                    case INSERT: {
                        int targetTupleIndex = ctx.leafFrame.findInsertTupleIndex(ctx.pred.getLowKey());
                        restartOp = this.insertLeaf(ctx.pred.getLowKey(), targetTupleIndex, pageId, ctx);
                        break;
                    }
                    case UPSERT: {
                        int targetTupleIndex = ctx.leafFrame.findUpsertTupleIndex(ctx.pred.getLowKey());
                        restartOp = this.upsertLeaf(ctx.pred.getLowKey(), targetTupleIndex, pageId, ctx);
                        break;
                    }
                    case UPDATE: {
                        int oldTupleIndex = ctx.leafFrame.findUpdateTupleIndex(ctx.pred.getLowKey());
                        restartOp = this.updateLeaf(ctx.pred.getLowKey(), oldTupleIndex, pageId, ctx);
                        break;
                    }
                    case DELETE: {
                        restartOp = this.deleteLeaf(node, pageId, ctx.pred.getLowKey(), ctx);
                        break;
                    }
                    case SEARCH: {
                        ctx.cursorInitialState.setSearchOperationCallback(ctx.searchCallback);
                        ctx.cursorInitialState.setOriginialKeyComparator(ctx.cmp);
                        ctx.cursorInitialState.setPage(node);
                        ctx.cursorInitialState.setPageId(pageId);
                        ctx.cursor.open((ICursorInitialState)ctx.cursorInitialState, (ISearchPredicate)ctx.pred);
                    }
                }
                if (ctx.op != IndexOperation.SEARCH) {
                    node.releaseWriteLatch(true);
                    this.bufferCache.unpin(node);
                }
                if (restartOp) {
                    this.treeLatch.readLock().lock();
                    this.treeLatch.readLock().unlock();
                    ctx.pageLsns.removeLast();
                    ctx.pageLsns.add(-9223372036854775807L);
                }
            }
            catch (TreeIndexException e) {
                if (!ctx.exceptionHandled && node != null) {
                    if (isReadLatched) {
                        node.releaseReadLatch();
                    } else {
                        node.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(node);
                    ctx.exceptionHandled = true;
                }
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (node != null) {
                    if (isReadLatched) {
                        node.releaseReadLatch();
                    } else {
                        node.releaseWriteLatch(true);
                    }
                    this.bufferCache.unpin(node);
                }
                BTreeException wrappedException = new BTreeException(e);
                ctx.exceptionHandled = true;
                throw wrappedException;
            }
        }
    }

    private BTreeOpContext createOpContext(IIndexAccessor accessor, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new BTreeOpContext(accessor, this.leafFrameFactory, this.interiorFrameFactory, this.freePageManager.getMetaDataFrameFactory().createFrame(), this.cmpFactories, modificationCallback, searchCallback);
    }

    public String printTree(IBTreeLeafFrame leafFrame, IBTreeInteriorFrame interiorFrame, ISerializerDeserializer[] keySerdes) throws Exception {
        MultiComparator cmp = MultiComparator.create((IBinaryComparatorFactory[])this.cmpFactories);
        byte treeHeight = this.getTreeHeight(leafFrame);
        StringBuilder strBuilder = new StringBuilder();
        this.printTree(1, null, false, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
        return strBuilder.toString();
    }

    public void printTree(int pageId, ICachedPage parent, boolean unpin, IBTreeLeafFrame leafFrame, IBTreeInteriorFrame interiorFrame, byte treeHeight, ISerializerDeserializer[] keySerdes, StringBuilder strBuilder, MultiComparator cmp) throws Exception {
        ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
        node.acquireReadLatch();
        try {
            String keyString;
            if (parent != null && unpin) {
                parent.releaseReadLatch();
                this.bufferCache.unpin(parent);
            }
            interiorFrame.setPage(node);
            byte level = interiorFrame.getLevel();
            strBuilder.append(String.format("%1d ", level));
            strBuilder.append(String.format("%3d ", pageId) + ": ");
            for (int i = 0; i < treeHeight - level; ++i) {
                strBuilder.append("    ");
            }
            if (interiorFrame.isLeaf()) {
                leafFrame.setPage(node);
                keyString = BTree.printLeafFrameTuples(leafFrame, keySerdes);
            } else {
                keyString = BTree.printInteriorFrameTuples(interiorFrame, keySerdes);
            }
            strBuilder.append(keyString + "\n");
            if (!interiorFrame.isLeaf()) {
                ArrayList<Integer> children = ((BTreeNSMInteriorFrame)interiorFrame).getChildren(cmp);
                for (int i = 0; i < children.size(); ++i) {
                    this.printTree(children.get(i), node, i == children.size() - 1, leafFrame, interiorFrame, treeHeight, keySerdes, strBuilder, cmp);
                }
            } else {
                node.releaseReadLatch();
                this.bufferCache.unpin(node);
            }
        }
        catch (Exception e) {
            node.releaseReadLatch();
            this.bufferCache.unpin(node);
            e.printStackTrace();
        }
    }

    public ITreeIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new BTreeAccessor(this, modificationCallback, searchCallback);
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new BTreeBulkLoader(fillFactor, verifyInput);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public static String printLeafFrameTuples(IBTreeLeafFrame leafFrame, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        ITreeIndexTupleReference tuple = leafFrame.createTupleReference();
        for (int i = 0; i < leafFrame.getTupleCount(); ++i) {
            tuple.resetByTupleIndex((ITreeIndexFrame)leafFrame, i);
            String tupleString = TupleUtils.printTuple((ITupleReference)tuple, (ISerializerDeserializer[])fieldSerdes);
            strBuilder.append(tupleString + " | ");
        }
        int rightPageId = leafFrame.getNextLeaf();
        strBuilder.append("(" + rightPageId + ")");
        return strBuilder.toString();
    }

    public static String printInteriorFrameTuples(IBTreeInteriorFrame interiorFrame, ISerializerDeserializer[] fieldSerdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        ITreeIndexTupleReference tuple = interiorFrame.createTupleReference();
        for (int i = 0; i < interiorFrame.getTupleCount(); ++i) {
            tuple.resetByTupleIndex((ITreeIndexFrame)interiorFrame, i);
            int numFields = tuple.getFieldCount();
            int childPageId = IntegerSerializerDeserializer.getInt((byte[])tuple.getFieldData(numFields - 1), (int)(tuple.getFieldStart(numFields - 1) + tuple.getFieldLength(numFields - 1)));
            strBuilder.append("(" + childPageId + ") ");
            String tupleString = TupleUtils.printTuple((ITupleReference)tuple, (ISerializerDeserializer[])fieldSerdes);
            strBuilder.append(tupleString + " | ");
        }
        int rightMostChildPageId = interiorFrame.getRightmostChildPageId();
        strBuilder.append("(" + rightMostChildPageId + ")");
        return strBuilder.toString();
    }

    public class BTreeBulkLoader
    extends AbstractTreeIndex.AbstractTreeIndexBulkLoader {
        protected final ISplitKey splitKey;
        protected final boolean verifyInput;

        public BTreeBulkLoader(float fillFactor, boolean verifyInput) throws TreeIndexException, HyracksDataException {
            super((AbstractTreeIndex)BTree.this, fillFactor);
            this.verifyInput = verifyInput;
            this.splitKey = new BTreeSplitKey(this.leafFrame.getTupleWriter().createTupleReference());
            this.splitKey.getTuple().setFieldCount(this.cmp.getKeyFieldCount());
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                int tupleSize = Math.max(this.leafFrame.getBytesRequriedToWriteTuple(tuple), this.interiorFrame.getBytesRequriedToWriteTuple(tuple));
                if (tupleSize > BTree.this.maxTupleSize) {
                    throw new TreeIndexException("Space required for record (" + tupleSize + ") larger than maximum acceptable size (" + BTree.this.maxTupleSize + ")");
                }
                NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
                int spaceNeeded = this.tupleWriter.bytesRequired(tuple) + this.slotSize;
                int spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    this.leafFrame.compress();
                    spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
                }
                if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                    leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
                    if (this.verifyInput) {
                        this.verifyInputTuple(tuple, (ITupleReference)leafFrontier.lastTuple);
                    }
                    int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)leafFrontier.lastTuple, 0, this.cmp.getKeyFieldCount());
                    this.splitKey.initData(splitKeySize);
                    this.tupleWriter.writeTupleFields((ITupleReference)leafFrontier.lastTuple, 0, this.cmp.getKeyFieldCount(), this.splitKey.getBuffer().array(), 0);
                    this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer(), 0);
                    this.splitKey.setLeftPage(leafFrontier.pageId);
                    leafFrontier.pageId = BTree.this.freePageManager.getFreePage(this.metaFrame);
                    ((IBTreeLeafFrame)this.leafFrame).setNextLeaf(leafFrontier.pageId);
                    leafFrontier.page.releaseWriteLatch(true);
                    BTree.this.bufferCache.unpin(leafFrontier.page);
                    this.splitKey.setRightPage(leafFrontier.pageId);
                    this.propagateBulk(1);
                    leafFrontier.page = BTree.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)BTree.this.fileId, (int)leafFrontier.pageId), true);
                    leafFrontier.page.acquireWriteLatch();
                    this.leafFrame.setPage(leafFrontier.page);
                    this.leafFrame.initBuffer((byte)0);
                } else if (this.verifyInput && this.leafFrame.getTupleCount() > 0) {
                    leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
                    this.verifyInputTuple(tuple, (ITupleReference)leafFrontier.lastTuple);
                }
                this.leafFrame.setPage(leafFrontier.page);
                ((IBTreeLeafFrame)this.leafFrame).insertSorted(tuple);
            }
            catch (IndexException e) {
                this.handleException();
                throw e;
            }
            catch (HyracksDataException e) {
                this.handleException();
                throw e;
            }
            catch (RuntimeException e) {
                this.handleException();
                throw e;
            }
        }

        protected void verifyInputTuple(ITupleReference tuple, ITupleReference prevTuple) throws IndexException, HyracksDataException {
            int cmpResult = this.cmp.compare(tuple, prevTuple);
            if (cmpResult < 0) {
                throw new UnsortedInputException("Input stream given to BTree bulk load is not sorted.");
            }
            if (cmpResult == 0) {
                throw new TreeIndexDuplicateKeyException("Input stream given to BTree bulk load has duplicates.");
            }
        }

        protected void propagateBulk(int level) throws HyracksDataException {
            if (this.splitKey.getBuffer() == null) {
                return;
            }
            if (level >= this.nodeFrontiers.size()) {
                this.addLevel();
            }
            NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
            this.interiorFrame.setPage(frontier.page);
            ITreeIndexTupleReference tuple = this.splitKey.getTuple();
            int spaceNeeded = this.tupleWriter.bytesRequired((ITupleReference)tuple, 0, this.cmp.getKeyFieldCount()) + this.slotSize + 4;
            int spaceUsed = this.interiorFrame.getBuffer().capacity() - this.interiorFrame.getTotalFreeSpace();
            if (spaceUsed + spaceNeeded > this.interiorMaxBytes) {
                ISplitKey copyKey = this.splitKey.duplicate(this.leafFrame.getTupleWriter().createTupleReference());
                tuple = copyKey.getTuple();
                frontier.lastTuple.resetByTupleIndex(this.interiorFrame, this.interiorFrame.getTupleCount() - 1);
                int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)frontier.lastTuple, 0, this.cmp.getKeyFieldCount());
                this.splitKey.initData(splitKeySize);
                this.tupleWriter.writeTupleFields((ITupleReference)frontier.lastTuple, 0, this.cmp.getKeyFieldCount(), this.splitKey.getBuffer().array(), 0);
                this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer(), 0);
                this.splitKey.setLeftPage(frontier.pageId);
                ((IBTreeInteriorFrame)this.interiorFrame).deleteGreatest();
                frontier.page.releaseWriteLatch(true);
                BTree.this.bufferCache.unpin(frontier.page);
                frontier.pageId = BTree.this.freePageManager.getFreePage(this.metaFrame);
                this.splitKey.setRightPage(frontier.pageId);
                this.propagateBulk(level + 1);
                frontier.page = BTree.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)BTree.this.fileId, (int)frontier.pageId), true);
                frontier.page.acquireWriteLatch();
                this.interiorFrame.setPage(frontier.page);
                this.interiorFrame.initBuffer((byte)level);
            }
            ((IBTreeInteriorFrame)this.interiorFrame).insertSorted((ITupleReference)tuple);
        }
    }

    public class BTreeAccessor
    implements ITreeIndexAccessor {
        private BTree btree;
        private BTreeOpContext ctx;

        public BTreeAccessor(BTree btree, IModificationOperationCallback modificationCalback, ISearchOperationCallback searchCallback) {
            this.btree = btree;
            this.ctx = btree.createOpContext((IIndexAccessor)this, modificationCalback, searchCallback);
        }

        public void insert(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.INSERT);
            this.btree.insert(tuple, this.ctx);
        }

        public void update(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.UPDATE);
            this.btree.update(tuple, this.ctx);
        }

        public void delete(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.btree.delete(tuple, this.ctx);
        }

        public void upsert(ITupleReference tuple) throws HyracksDataException, TreeIndexException {
            this.upsertIfConditionElseInsert(tuple, UnconditionalTupleAcceptor.INSTANCE);
        }

        public void upsertIfConditionElseInsert(ITupleReference tuple, ITupleAcceptor acceptor) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.UPSERT);
            this.ctx.acceptor = acceptor;
            this.btree.upsert(tuple, this.ctx);
        }

        public ITreeIndexCursor createSearchCursor(boolean exclusive) {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new BTreeRangeSearchCursor(leafFrame, exclusive);
        }

        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException, TreeIndexException {
            this.ctx.setOperation(IndexOperation.SEARCH);
            this.btree.search((ITreeIndexCursor)cursor, searchPred, this.ctx);
        }

        public ITreeIndexCursor createDiskOrderScanCursor() {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new TreeIndexDiskOrderScanCursor((ITreeIndexFrame)leafFrame);
        }

        public void diskOrderScan(ITreeIndexCursor cursor) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DISKORDERSCAN);
            this.btree.diskOrderScan(cursor, this.ctx);
        }

        public BTreeOpContext getOpContext() {
            return this.ctx;
        }

        public ITreeIndexCursor createCountingSearchCursor() {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new BTreeCountingSearchCursor(leafFrame, false);
        }
    }
}

