/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.frames;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import edu.uci.ics.hyracks.storage.am.btree.frames.OrderedSlotManager;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeOpContext;
import edu.uci.ics.hyracks.storage.am.common.api.ISlotManager;
import edu.uci.ics.hyracks.storage.am.common.api.ISplitKey;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.api.TreeIndexException;
import edu.uci.ics.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import edu.uci.ics.hyracks.storage.am.common.exceptions.TreeIndexNonExistentKeyException;
import edu.uci.ics.hyracks.storage.am.common.frames.TreeIndexNSMFrame;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.FindTupleMode;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import java.nio.ByteBuffer;

public class BTreeNSMLeafFrame
extends TreeIndexNSMFrame
implements IBTreeLeafFrame {
    protected static final int nextLeafOff = 22;
    private MultiComparator cmp;
    private final ITreeIndexTupleReference previousFt;

    public BTreeNSMLeafFrame(ITreeIndexTupleWriter tupleWriter) {
        super(tupleWriter, (ISlotManager)new OrderedSlotManager());
        this.previousFt = tupleWriter.createTupleReference();
    }

    public int getBytesRequriedToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + this.slotManager.getSlotSize();
    }

    public void initBuffer(byte level) {
        super.initBuffer(level);
        this.buf.putInt(22, -1);
    }

    @Override
    public void setNextLeaf(int page) {
        this.buf.putInt(22, page);
    }

    @Override
    public int getNextLeaf() {
        return this.buf.getInt(22);
    }

    @Override
    public int findInsertTupleIndex(ITupleReference tuple) throws TreeIndexException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.EXCLUSIVE_ERROR_IF_EXISTS, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        if (tupleIndex == this.slotManager.getErrorIndicator()) {
            throw new TreeIndexDuplicateKeyException("Trying to insert duplicate key into leaf node.");
        }
        return tupleIndex;
    }

    @Override
    public int findUpdateTupleIndex(ITupleReference tuple) throws TreeIndexException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.EXACT, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        if (tupleIndex == this.slotManager.getErrorIndicator() || tupleIndex == this.slotManager.getGreatestKeyIndicator()) {
            throw new TreeIndexNonExistentKeyException("Trying to update a tuple with a nonexistent key in leaf node.");
        }
        return tupleIndex;
    }

    @Override
    public int findUpsertTupleIndex(ITupleReference tuple) throws TreeIndexException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.INCLUSIVE, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        return tupleIndex;
    }

    @Override
    public ITupleReference getMatchingKeyTuple(ITupleReference searchTuple, int targetTupleIndex) {
        if (targetTupleIndex != this.slotManager.getGreatestKeyIndicator()) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, targetTupleIndex);
            if (this.cmp.compare(searchTuple, (ITupleReference)this.frameTuple) == 0) {
                return this.frameTuple;
            }
        }
        return null;
    }

    @Override
    public int findDeleteTupleIndex(ITupleReference tuple) throws TreeIndexException {
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.EXACT, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        if (tupleIndex == this.slotManager.getErrorIndicator() || tupleIndex == this.slotManager.getGreatestKeyIndicator()) {
            throw new TreeIndexNonExistentKeyException("Trying to delete a tuple with a nonexistent key in leaf node.");
        }
        return tupleIndex;
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        int freeSpace = this.buf.getInt(12);
        this.slotManager.insertSlot(tupleIndex, freeSpace);
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf.array(), freeSpace);
        this.buf.putInt(8, this.buf.getInt(8) + 1);
        this.buf.putInt(12, this.buf.getInt(12) + bytesWritten);
        this.buf.putInt(16, this.buf.getInt(16) - bytesWritten - this.slotManager.getSlotSize());
    }

    @Override
    public void insertSorted(ITupleReference tuple) {
        this.insert(tuple, this.slotManager.getGreatestKeyIndicator());
    }

    public void split(ITreeIndexFrame rightFrame, ITupleReference tuple, ISplitKey splitKey) {
        int targetTupleIndex;
        ByteBuffer right = rightFrame.getBuffer();
        int tupleCount = this.getTupleCount();
        ITreeIndexFrame targetFrame = null;
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleCount - 1);
        if (this.cmp.compare(tuple, (ITupleReference)this.frameTuple) > 0) {
            targetFrame = rightFrame;
        } else {
            int tuplesToLeft;
            int i;
            int totalSize = 0;
            int halfPageSize = (this.buf.capacity() - this.getPageHeaderSize()) / 2;
            for (i = 0; i < tupleCount; ++i) {
                this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
                if ((totalSize += this.tupleWriter.getCopySpaceRequired((ITupleReference)this.frameTuple) + this.slotManager.getSlotSize()) >= halfPageSize) break;
            }
            if (this.cmp.compare(tuple, (ITupleReference)this.frameTuple) >= 0) {
                tuplesToLeft = i + 1;
                targetFrame = rightFrame;
            } else {
                tuplesToLeft = i;
                targetFrame = this;
            }
            int tuplesToRight = tupleCount - tuplesToLeft;
            System.arraycopy(this.buf.array(), 0, right.array(), 0, this.buf.capacity());
            int src = rightFrame.getSlotManager().getSlotEndOff();
            int dest = rightFrame.getSlotManager().getSlotEndOff() + tuplesToLeft * rightFrame.getSlotManager().getSlotSize();
            int length = rightFrame.getSlotManager().getSlotSize() * tuplesToRight;
            System.arraycopy(right.array(), src, right.array(), dest, length);
            right.putInt(8, tuplesToRight);
            this.buf.putInt(8, tuplesToLeft);
            rightFrame.compact();
            this.compact();
        }
        try {
            targetTupleIndex = ((BTreeNSMLeafFrame)targetFrame).findInsertTupleIndex(tuple);
        }
        catch (TreeIndexException e) {
            throw new IllegalStateException(e);
        }
        targetFrame.insert(tuple, targetTupleIndex);
        int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotEndOff());
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount());
        splitKey.initData(splitKeySize);
        this.tupleWriter.writeTupleFields((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount(), splitKey.getBuffer().array(), 0);
        splitKey.getTuple().resetByTupleOffset(splitKey.getBuffer(), 0);
    }

    protected void resetSpaceParams() {
        this.buf.putInt(12, 26);
        this.buf.putInt(16, this.buf.capacity() - 26);
    }

    public ITreeIndexTupleReference createTupleReference() {
        return this.tupleWriter.createTupleReference();
    }

    @Override
    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference pageTuple, MultiComparator cmp, FindTupleMode ftm, FindTupleNoExactMatchPolicy ftp) {
        return this.slotManager.findTupleIndex(searchKey, pageTuple, cmp, ftm, ftp);
    }

    public int getPageHeaderSize() {
        return 26;
    }

    @Override
    public boolean getSmFlag() {
        return this.buf.get(21) != 0;
    }

    @Override
    public void setSmFlag(boolean smFlag) {
        if (smFlag) {
            this.buf.put(21, (byte)1);
        } else {
            this.buf.put(21, (byte)0);
        }
    }

    public void setMultiComparator(MultiComparator cmp) {
        this.cmp = cmp;
    }

    @Override
    public void validate(BTreeOpContext.PageValidationInfo pvi) throws HyracksDataException {
        int tupleCount = this.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            if (!pvi.isLowRangeNull) assert (this.cmp.compare((ITupleReference)pvi.lowRangeTuple, (ITupleReference)this.frameTuple) < 0);
            if (!pvi.isHighRangeNull) assert (this.cmp.compare((ITupleReference)pvi.highRangeTuple, (ITupleReference)this.frameTuple) >= 0);
            if (i <= 0) continue;
            this.previousFt.resetByTupleIndex((ITreeIndexFrame)this, i - 1);
            assert (this.cmp.compare((ITupleReference)this.previousFt, (ITupleReference)this.frameTuple) < 0);
        }
    }
}

