/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.frames;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeInteriorFrame;
import edu.uci.ics.hyracks.storage.am.btree.frames.OrderedSlotManager;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeOpContext;
import edu.uci.ics.hyracks.storage.am.btree.impls.RangePredicate;
import edu.uci.ics.hyracks.storage.am.common.api.ISlotManager;
import edu.uci.ics.hyracks.storage.am.common.api.ISplitKey;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.api.TreeIndexException;
import edu.uci.ics.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import edu.uci.ics.hyracks.storage.am.common.frames.TreeIndexNSMFrame;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.FindTupleMode;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.SlotOffTupleOff;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;

public class BTreeNSMInteriorFrame
extends TreeIndexNSMFrame
implements IBTreeInteriorFrame {
    private static final int rightLeafOff = 22;
    private static final int childPtrSize = 4;
    private final ITreeIndexTupleReference cmpFrameTuple;
    private final ITreeIndexTupleReference previousFt;
    private MultiComparator cmp;

    public BTreeNSMInteriorFrame(ITreeIndexTupleWriter tupleWriter) {
        super(tupleWriter, (ISlotManager)new OrderedSlotManager());
        this.cmpFrameTuple = tupleWriter.createTupleReference();
        this.previousFt = tupleWriter.createTupleReference();
    }

    public int getBytesRequriedToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + 4 + this.slotManager.getSlotSize();
    }

    public void initBuffer(byte level) {
        super.initBuffer(level);
        this.buf.putInt(22, -1);
    }

    @Override
    public int findInsertTupleIndex(ITupleReference tuple) throws TreeIndexException {
        return this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.INCLUSIVE, FindTupleNoExactMatchPolicy.HIGHER_KEY);
    }

    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) {
        int bytesRequired = this.tupleWriter.bytesRequired(tuple) + 4 + this.slotManager.getSlotSize();
        if (bytesRequired <= this.getFreeContiguousSpace()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired <= this.getTotalFreeSpace()) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        int slotOff = this.slotManager.insertSlot(tupleIndex, this.buf.getInt(12));
        int freeSpace = this.buf.getInt(12);
        int bytesWritten = this.tupleWriter.writeTupleFields(tuple, 0, tuple.getFieldCount(), this.buf.array(), freeSpace);
        System.arraycopy(tuple.getFieldData(tuple.getFieldCount() - 1), this.getLeftChildPageOff(tuple), this.buf.array(), freeSpace + bytesWritten, 4);
        int tupleSize = bytesWritten + 4;
        this.buf.putInt(8, this.buf.getInt(8) + 1);
        this.buf.putInt(12, this.buf.getInt(12) + tupleSize);
        this.buf.putInt(16, this.buf.getInt(16) - tupleSize - this.slotManager.getSlotSize());
        if (slotOff == this.slotManager.getSlotEndOff()) {
            System.arraycopy(tuple.getFieldData(tuple.getFieldCount() - 1), this.getLeftChildPageOff(tuple) + 4, this.buf.array(), 22, 4);
        } else if (this.buf.getInt(8) > 1) {
            int rightNeighborOff = slotOff - this.slotManager.getSlotSize();
            this.frameTuple.resetByTupleOffset(this.buf, this.slotManager.getTupleOff(rightNeighborOff));
            System.arraycopy(tuple.getFieldData(0), this.getLeftChildPageOff(tuple) + 4, this.buf.array(), this.getLeftChildPageOff((ITupleReference)this.frameTuple), 4);
        }
    }

    @Override
    public int findDeleteTupleIndex(ITupleReference tuple) throws TreeIndexException {
        return this.slotManager.findTupleIndex(tuple, this.frameTuple, this.cmp, FindTupleMode.INCLUSIVE, FindTupleNoExactMatchPolicy.HIGHER_KEY);
    }

    public void delete(ITupleReference tuple, int tupleIndex) {
        int keySize;
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        if (tupleIndex == this.slotManager.getGreatestKeyIndicator()) {
            int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotEndOff());
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            keySize = this.frameTuple.getTupleSize();
            System.arraycopy(this.buf.array(), tupleOff + keySize, this.buf.array(), 22, 4);
        } else {
            int tupleOff = this.slotManager.getTupleOff(slotOff);
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            keySize = this.frameTuple.getTupleSize();
            int slotStartOff = this.slotManager.getSlotEndOff();
            int length = slotOff - slotStartOff;
            System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        }
        this.buf.putInt(8, this.buf.getInt(8) - 1);
        this.buf.putInt(16, this.buf.getInt(16) + keySize + 4 + this.slotManager.getSlotSize());
    }

    @Override
    public void deleteGreatest() {
        int slotOff = this.slotManager.getSlotEndOff();
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int keySize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple);
        System.arraycopy(this.buf.array(), tupleOff + keySize, this.buf.array(), 22, 4);
        this.buf.putInt(8, this.buf.getInt(8) - 1);
        this.buf.putInt(16, this.buf.getInt(16) + keySize + 4 + this.slotManager.getSlotSize());
        int freeSpace = this.buf.getInt(12);
        if (freeSpace == tupleOff + keySize + 4) {
            this.buf.putInt(freeSpace, freeSpace - (keySize + 4));
        }
    }

    public FrameOpSpaceStatus hasSpaceUpdate(ITupleReference tuple, int oldTupleIndex) {
        throw new UnsupportedOperationException("Cannot update tuples in interior node.");
    }

    @Override
    public void insertSorted(ITupleReference tuple) {
        int freeSpace = this.buf.getInt(12);
        this.slotManager.insertSlot(this.slotManager.getGreatestKeyIndicator(), freeSpace);
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf, freeSpace);
        System.arraycopy(tuple.getFieldData(tuple.getFieldCount() - 1), this.getLeftChildPageOff(tuple), this.buf.array(), freeSpace + bytesWritten, 4);
        int tupleSize = bytesWritten + 4;
        this.buf.putInt(8, this.buf.getInt(8) + 1);
        this.buf.putInt(12, this.buf.getInt(12) + tupleSize);
        this.buf.putInt(16, this.buf.getInt(16) - tupleSize - this.slotManager.getSlotSize());
        System.arraycopy(tuple.getFieldData(0), this.getLeftChildPageOff(tuple) + 4, this.buf.array(), 22, 4);
    }

    public void split(ITreeIndexFrame rightFrame, ITupleReference tuple, ISplitKey splitKey) {
        int targetTupleIndex;
        int tuplesToLeft;
        ByteBuffer right = rightFrame.getBuffer();
        int tupleCount = this.getTupleCount();
        ITreeIndexFrame targetFrame = null;
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleCount - 1);
        if (this.cmp.compare(tuple, (ITupleReference)this.frameTuple) > 0) {
            targetFrame = rightFrame;
            tuplesToLeft = tupleCount;
        } else {
            int i;
            int totalSize = 0;
            int halfPageSize = (this.buf.capacity() - this.getPageHeaderSize()) / 2;
            for (i = 0; i < tupleCount; ++i) {
                this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
                if ((totalSize += this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple) + 4 + this.slotManager.getSlotSize()) >= halfPageSize) break;
            }
            if (this.cmp.compare(tuple, (ITupleReference)this.frameTuple) > 0) {
                tuplesToLeft = i;
                targetFrame = rightFrame;
            } else {
                tuplesToLeft = i + 1;
                targetFrame = this;
            }
            int tuplesToRight = tupleCount - tuplesToLeft;
            System.arraycopy(this.buf.array(), 0, right.array(), 0, this.buf.capacity());
            int src = rightFrame.getSlotManager().getSlotEndOff();
            int dest = rightFrame.getSlotManager().getSlotEndOff() + tuplesToLeft * rightFrame.getSlotManager().getSlotSize();
            int length = rightFrame.getSlotManager().getSlotSize() * tuplesToRight;
            System.arraycopy(right.array(), src, right.array(), dest, length);
            right.putInt(8, tuplesToRight);
            this.buf.putInt(8, tuplesToLeft);
        }
        ISplitKey savedSplitKey = splitKey.duplicate(this.tupleWriter.createTupleReference());
        int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotEndOff());
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple, 0, this.cmp.getKeyFieldCount());
        splitKey.initData(splitKeySize);
        this.tupleWriter.writeTuple((ITupleReference)this.frameTuple, splitKey.getBuffer(), 0);
        splitKey.getTuple().resetByTupleOffset(splitKey.getBuffer(), 0);
        int deleteTupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotEndOff());
        this.frameTuple.resetByTupleOffset(this.buf, deleteTupleOff);
        this.buf.putInt(22, this.buf.getInt(this.getLeftChildPageOff((ITupleReference)this.frameTuple)));
        this.buf.putInt(8, tuplesToLeft - 1);
        rightFrame.compact();
        this.compact();
        try {
            targetTupleIndex = ((BTreeNSMInteriorFrame)targetFrame).findInsertTupleIndex((ITupleReference)savedSplitKey.getTuple());
        }
        catch (TreeIndexException e) {
            throw new IllegalStateException(e);
        }
        targetFrame.insert((ITupleReference)savedSplitKey.getTuple(), targetTupleIndex);
    }

    public boolean compact() {
        int i;
        this.resetSpaceParams();
        int tupleCount = this.buf.getInt(8);
        int freeSpace = this.buf.getInt(12);
        ArrayList<SlotOffTupleOff> sortedTupleOffs = new ArrayList<SlotOffTupleOff>();
        sortedTupleOffs.ensureCapacity(tupleCount);
        for (i = 0; i < tupleCount; ++i) {
            int slotOff = this.slotManager.getSlotOff(i);
            int tupleOff = this.slotManager.getTupleOff(slotOff);
            sortedTupleOffs.add(new SlotOffTupleOff(i, slotOff, tupleOff));
        }
        Collections.sort(sortedTupleOffs);
        for (i = 0; i < sortedTupleOffs.size(); ++i) {
            int tupleOff = ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleOff;
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            int tupleEndOff = this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1);
            int tupleLength = tupleEndOff - tupleOff + 4;
            System.arraycopy(this.buf.array(), tupleOff, this.buf.array(), freeSpace, tupleLength);
            this.slotManager.setSlot(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff, freeSpace);
            freeSpace += tupleLength;
        }
        this.buf.putInt(12, freeSpace);
        this.buf.putInt(16, this.buf.capacity() - freeSpace - tupleCount * this.slotManager.getSlotSize());
        return false;
    }

    @Override
    public int getChildPageId(RangePredicate pred) throws HyracksDataException {
        if (this.buf.getInt(8) == 0) {
            return this.buf.getInt(22);
        }
        ITupleReference tuple = null;
        FindTupleMode fsm = null;
        MultiComparator targetCmp = pred.getLowKeyComparator();
        tuple = pred.getLowKey();
        if (tuple == null) {
            return this.getLeftmostChildPageId();
        }
        fsm = pred.isLowKeyInclusive() ? FindTupleMode.INCLUSIVE : FindTupleMode.EXCLUSIVE;
        int tupleIndex = this.slotManager.findTupleIndex(tuple, this.frameTuple, targetCmp, fsm, FindTupleNoExactMatchPolicy.HIGHER_KEY);
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        if (tupleIndex == this.slotManager.getGreatestKeyIndicator()) {
            return this.buf.getInt(22);
        }
        int origTupleOff = this.slotManager.getTupleOff(slotOff);
        this.cmpFrameTuple.resetByTupleOffset(this.buf, origTupleOff);
        int cmpTupleOff = origTupleOff;
        int maxSlotOff = this.buf.capacity();
        slotOff += this.slotManager.getSlotSize();
        while (slotOff < maxSlotOff) {
            cmpTupleOff = this.slotManager.getTupleOff(slotOff);
            this.frameTuple.resetByTupleOffset(this.buf, cmpTupleOff);
            if (targetCmp.compare((ITupleReference)this.cmpFrameTuple, (ITupleReference)this.frameTuple) != 0) break;
            slotOff += this.slotManager.getSlotSize();
        }
        this.frameTuple.resetByTupleOffset(this.buf, this.slotManager.getTupleOff(slotOff -= this.slotManager.getSlotSize()));
        int childPageOff = this.getLeftChildPageOff((ITupleReference)this.frameTuple);
        return this.buf.getInt(childPageOff);
    }

    protected void resetSpaceParams() {
        this.buf.putInt(12, 26);
        this.buf.putInt(16, this.buf.capacity() - 26);
    }

    @Override
    public int getLeftmostChildPageId() {
        int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotStartOff());
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int childPageOff = this.getLeftChildPageOff((ITupleReference)this.frameTuple);
        return this.buf.getInt(childPageOff);
    }

    @Override
    public int getRightmostChildPageId() {
        return this.buf.getInt(22);
    }

    @Override
    public void setRightmostChildPageId(int pageId) {
        this.buf.putInt(22, pageId);
    }

    public int getPageHeaderSize() {
        return 26;
    }

    private int getLeftChildPageOff(ITupleReference tuple) {
        return tuple.getFieldStart(tuple.getFieldCount() - 1) + tuple.getFieldLength(tuple.getFieldCount() - 1);
    }

    @Override
    public boolean getSmFlag() {
        return this.buf.get(21) != 0;
    }

    @Override
    public void setSmFlag(boolean smFlag) {
        if (smFlag) {
            this.buf.put(21, (byte)1);
        } else {
            this.buf.put(21, (byte)0);
        }
    }

    public void setMultiComparator(MultiComparator cmp) {
        this.cmp = cmp;
        this.cmpFrameTuple.setFieldCount(cmp.getKeyFieldCount());
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        this.previousFt.setFieldCount(cmp.getKeyFieldCount());
    }

    public ITreeIndexTupleReference createTupleReference() {
        ITreeIndexTupleReference tuple = this.tupleWriter.createTupleReference();
        tuple.setFieldCount(this.cmp.getKeyFieldCount());
        return tuple;
    }

    public ArrayList<Integer> getChildren(MultiComparator cmp) {
        int rightLeaf;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int tupleCount = this.buf.getInt(8);
        for (int i = 0; i < tupleCount; ++i) {
            int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotOff(i));
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            int intVal = IntegerSerializerDeserializer.getInt((byte[])this.buf.array(), (int)(this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1)));
            ret.add(intVal);
        }
        if (!this.isLeaf() && (rightLeaf = this.buf.getInt(22)) > 0) {
            ret.add(this.buf.getInt(22));
        }
        return ret;
    }

    @Override
    public void validate(BTreeOpContext.PageValidationInfo pvi) throws HyracksDataException {
        int tupleCount = this.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            if (!pvi.isLowRangeNull) assert (this.cmp.compare((ITupleReference)pvi.lowRangeTuple, (ITupleReference)this.frameTuple) < 0);
            if (!pvi.isHighRangeNull) assert (this.cmp.compare((ITupleReference)pvi.highRangeTuple, (ITupleReference)this.frameTuple) >= 0);
            if (i <= 0) continue;
            this.previousFt.resetByTupleIndex((ITreeIndexFrame)this, i - 1);
            assert (this.cmp.compare((ITupleReference)this.previousFt, (ITupleReference)this.frameTuple) < 0);
        }
    }
}

