/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.btree.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import edu.uci.ics.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndex;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITupleUpdater;
import edu.uci.ics.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import java.nio.ByteBuffer;

public class BTreeUpdateSearchOperatorNodePushable
extends BTreeSearchOperatorNodePushable {
    private final ITupleUpdater tupleUpdater;

    public BTreeUpdateSearchOperatorNodePushable(AbstractTreeIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IRecordDescriptorProvider recordDescProvider, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, ITupleUpdater tupleUpdater) {
        super(opDesc, ctx, partition, recordDescProvider, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive);
        this.tupleUpdater = tupleUpdater;
    }

    protected ITreeIndexCursor createCursor() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        ITreeIndexFrame cursorFrame = treeIndex.getLeafFrameFactory().createFrame();
        return new BTreeRangeSearchCursor((IBTreeLeafFrame)cursorFrame, true);
    }

    protected void writeSearchResults(int tupleIndex) throws Exception {
        while (this.cursor.hasNext()) {
            this.tb.reset();
            this.cursor.next();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            ITupleReference tuple = this.cursor.getTuple();
            this.tupleUpdater.updateTuple(tuple);
            for (int i = 0; i < tuple.getFieldCount(); ++i) {
                this.dos.write(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
                this.tb.addFieldEndOffset();
            }
            if (this.appender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) continue;
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer, (IFrameWriter)this.writer);
            this.appender.reset(this.writeBuffer, true);
            if (this.appender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) continue;
            throw new HyracksDataException("Record size (" + this.tb.getSize() + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
        }
    }
}

